-- phpMyAdmin SQL Dump
-- version 4.0.10deb1
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Generation Time: Nov 13, 2014 at 03:19 PM
-- Server version: 5.5.40-0ubuntu0.14.04.1
-- PHP Version: 5.5.9-1ubuntu4.5

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `pathways`
--

-- --------------------------------------------------------

--
-- Table structure for table `1_scenario_parameter`
--

CREATE TABLE IF NOT EXISTS `1_scenario_parameter` (
  `scenario_nr` int(10) NOT NULL COMMENT 'unique number 1 to 99999',
  `scenario_year` int(4) NOT NULL COMMENT 'one year in the range 2011 to 2050',
  `start_hour` int(10) NOT NULL DEFAULT '1' COMMENT 'possible: 1 - 8759(hour)',
  `end_hour` int(10) NOT NULL DEFAULT '8760' COMMENT 'possible: 2-8760',
  `time_unit` enum('hour','quarter') CHARACTER SET utf8 NOT NULL DEFAULT 'hour' COMMENT 'timesteps: hour or quarter?',
  `weather_year` enum('1998','2003','2010') CHARACTER SET utf8 NOT NULL DEFAULT '2010',
  `algorithm_scenario` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'standard',
  `demand_scenario` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT 'status_quo_2010',
  `grid_scenario` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'status_quo_2012',
  `region_scenario` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT 'germany21_all_countries',
  `renewable_scenario` varchar(50) CHARACTER SET utf8 NOT NULL,
  `resources_scenario` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT 'moderate',
  `storage_scenario` varchar(50) CHARACTER SET utf8 NOT NULL,
  `thermal_pp_scenario` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'lifetime_40years',
  PRIMARY KEY (`scenario_nr`),
  KEY `algorithm_scenario` (`algorithm_scenario`),
  KEY `demand_scenario` (`demand_scenario`),
  KEY `grid_scenario` (`grid_scenario`),
  KEY `region_scenario` (`region_scenario`),
  KEY `renewable_scenario` (`renewable_scenario`),
  KEY `resources_scenario` (`resources_scenario`),
  KEY `storage_scenario` (`storage_scenario`),
  KEY `thermal_pp_scenario` (`thermal_pp_scenario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `1_scenario_parameter`
--

INSERT INTO `1_scenario_parameter` (`scenario_nr`, `scenario_year`, `start_hour`, `end_hour`, `time_unit`, `weather_year`, `algorithm_scenario`, `demand_scenario`, `grid_scenario`, `region_scenario`, `renewable_scenario`, `resources_scenario`, `storage_scenario`, `thermal_pp_scenario`) VALUES
(1, 2014, 1, 4, 'hour', '2010', 'standard', 'status_quo_2010', 'status_quo_2012', 'germany2', 'status_quo_2012', 'low', 'status_quo_2012', 'status_quo_2012_DE_lifetime_40years'),
(2, 2050, 1, 24, 'hour', '2010', 'standard', 'status_quo_2010', 'planned_2015', 'germany21_all_countries', 'NEP_2034_B', 'low', 'NEP_2023_hydro', 'status_quo_2012'),
(3, 2024, 2161, 2184, 'quarter', '2010', 'standard', 'status_quo_2010', 'status_quo_2012_distance', 'germany5_norway', 'NEP_2034_B', 'low', 'plus_hydro_Norway10GW', 'lifetime_40years'),
(4, 2024, 4345, 4368, 'hour', '2010', 'standard', 'status_quo_2010', 'planned_2015_distance', 'germany21_neighbours', 'UBA_2050_Regionenverbund', 'high', 'status_quo_2012', 'no_fossils'),
(5, 2034, 6552, 6576, 'hour', '2010', 'standard', 'status_quo_2010', 'status_quo_2012', 'germany5', 'NEP_2024_C', 'high', 'NEP_2023_hydro', 'status_quo_2012_DE_lifetime_40years'),
(6, 2014, 1, 744, 'hour', '2010', 'standard', 'status_quo_2010', 'planned_2015', 'germany_neighbours_no_split', 'NEP_2024_A', 'high', 'plus_hydro_Norway10GW', 'status_quo_2012'),
(7, 2050, 4345, 5088, 'hour', '2010', 'standard', 'status_quo_2010', 'status_quo_2012_distance', 'germany5_all_countries', 'NEP_2024_B', 'moderate', 'status_quo_2012', 'lifetime_40years'),
(8, 2014, 1, 8760, 'hour', '2010', 'standard', 'status_quo_2010', 'planned_2015_distance', 'germany21_all_countries', 'status_quo_2012', 'moderate', 'NEP_2023_hydro', 'no_fossils'),
(9, 2024, 1, 8760, 'hour', '1998', 'standard', 'status_quo_2010', 'status_quo_2012', 'germany5_neighbours', 'status_quo_2012', 'moderate', 'plus_hydro_Norway10GW', 'status_quo_2012_DE_lifetime_40years'),
(10, 2050, 1, 8760, 'quarter', '2003', 'standard', 'status_quo_2010', 'planned_2015_distance', 'all_countries_no_split', 'UBA_2050_Regionenverbund', 'high', 'status_quo_2012', 'no_fossils');

-- --------------------------------------------------------

--
-- Table structure for table `algorithm_scenario`
--

CREATE TABLE IF NOT EXISTS `algorithm_scenario` (
  `scenario_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'standard',
  `algorithm` varchar(40) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'random' COMMENT 'random or simulated annealing',
  `iterations` int(10) NOT NULL DEFAULT '3000',
  PRIMARY KEY (`scenario_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `algorithm_scenario`
--

INSERT INTO `algorithm_scenario` (`scenario_name`, `algorithm`, `iterations`) VALUES
('simulated_annealing', 'simulated_annealing', 3000),
('standard', 'standard', 3000);

-- --------------------------------------------------------

--
-- Table structure for table `biomass_scenario`
--

CREATE TABLE IF NOT EXISTS `biomass_scenario` (
  `scenario_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount_of_biomass` decimal(10,2) NOT NULL COMMENT 'GWh that we could get from the biomass available for the whole year',
  `region_id` int(8) NOT NULL DEFAULT '0',
  `installed_capacity` decimal(10,2) DEFAULT NULL COMMENT '[MW] including the already installed capacities',
  PRIMARY KEY (`scenario_name`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `biomass_scenario`
--

INSERT INTO `biomass_scenario` (`scenario_name`, `amount_of_biomass`, `region_id`, `installed_capacity`) VALUES
('NEP_2024_A', 7386.00, 11001, 1152.00),
('NEP_2024_A', 641.00, 11002, 100.00),
('NEP_2024_A', 3436.00, 11003, 536.00),
('NEP_2024_A', 2638.00, 11004, 412.00),
('NEP_2024_A', 1738.00, 11005, 271.00),
('NEP_2024_A', 1794.00, 11006, 280.00),
('NEP_2024_A', 1870.00, 11007, 292.00),
('NEP_2024_A', 1343.00, 11008, 210.00),
('NEP_2024_A', 1301.00, 11009, 203.00),
('NEP_2024_A', 1616.00, 11010, 252.00),
('NEP_2024_A', 1195.00, 11011, 186.00),
('NEP_2024_A', 3933.00, 11012, 614.00),
('NEP_2024_A', 3205.00, 11013, 500.00),
('NEP_2024_A', 4748.00, 11014, 741.00),
('NEP_2024_A', 4926.00, 11015, 769.00),
('NEP_2024_A', 2151.00, 11016, 336.00),
('NEP_2024_A', 4639.00, 11017, 724.00),
('NEP_2024_A', 4001.00, 11018, 624.00),
('NEP_2024_B', 7731.00, 11001, 1236.00),
('NEP_2024_B', 626.00, 11002, 100.00),
('NEP_2024_B', 3355.00, 11003, 536.00),
('NEP_2024_B', 2680.00, 11004, 428.00),
('NEP_2024_B', 1697.00, 11005, 271.00),
('NEP_2024_B', 1751.00, 11006, 280.00),
('NEP_2024_B', 1825.00, 11007, 292.00),
('NEP_2024_B', 1311.00, 11008, 210.00),
('NEP_2024_B', 1270.00, 11009, 203.00),
('NEP_2024_B', 1676.00, 11010, 268.00),
('NEP_2024_B', 1167.00, 11011, 186.00),
('NEP_2024_B', 3839.00, 11012, 614.00),
('NEP_2024_B', 3129.00, 11013, 500.00),
('NEP_2024_B', 4635.00, 11014, 741.00),
('NEP_2024_B', 4809.00, 11015, 769.00),
('NEP_2024_B', 2099.00, 11016, 336.00),
('NEP_2024_B', 4811.00, 11017, 769.00),
('NEP_2024_B', 4150.00, 11018, 663.00),
('NEP_2024_C', 7778.00, 11001, 1169.00),
('NEP_2024_C', 665.00, 11002, 100.00),
('NEP_2024_C', 4209.00, 11003, 633.00),
('NEP_2024_C', 2651.00, 11004, 398.00),
('NEP_2024_C', 1594.00, 11005, 240.00),
('NEP_2024_C', 1655.00, 11006, 249.00),
('NEP_2024_C', 1725.00, 11007, 259.00),
('NEP_2024_C', 1313.00, 11008, 197.00),
('NEP_2024_C', 2149.00, 11009, 323.00),
('NEP_2024_C', 1468.00, 11010, 221.00),
('NEP_2024_C', 1241.00, 11011, 186.00),
('NEP_2024_C', 4082.00, 11012, 614.00),
('NEP_2024_C', 2661.00, 11013, 400.00),
('NEP_2024_C', 4348.00, 11014, 654.00),
('NEP_2024_C', 4515.00, 11015, 679.00),
('NEP_2024_C', 2661.00, 11016, 400.00),
('NEP_2024_C', 4213.00, 11017, 633.00),
('NEP_2024_C', 3634.00, 11018, 546.00),
('NEP_2034_B', 7570.00, 11001, 1383.00),
('NEP_2034_B', 548.00, 11002, 100.00),
('NEP_2034_B', 3750.00, 11003, 685.00),
('NEP_2034_B', 2914.00, 11004, 532.00),
('NEP_2034_B', 1657.00, 11005, 303.00),
('NEP_2034_B', 1702.00, 11006, 311.00),
('NEP_2034_B', 1774.00, 11007, 324.00),
('NEP_2034_B', 1390.00, 11008, 254.00),
('NEP_2034_B', 1503.00, 11009, 275.00),
('NEP_2034_B', 1639.00, 11010, 299.00),
('NEP_2034_B', 1149.00, 11011, 210.00),
('NEP_2034_B', 3779.00, 11012, 690.00),
('NEP_2034_B', 3285.00, 11013, 600.00),
('NEP_2034_B', 4532.00, 11014, 828.00),
('NEP_2034_B', 4700.00, 11015, 859.00),
('NEP_2034_B', 1903.00, 11016, 348.00),
('NEP_2034_B', 4705.00, 11017, 859.00),
('NEP_2034_B', 4058.00, 11018, 741.00),
('status_quo_2012', 7782.10, 11001, 888.37),
('status_quo_2012', 356.66, 11002, 40.72),
('status_quo_2012', 2734.71, 11003, 312.18),
('status_quo_2012', 1047.00, 11004, 119.52),
('status_quo_2012', 2556.33, 11005, 291.82),
('status_quo_2012', 2247.98, 11006, 256.62),
('status_quo_2012', 2067.46, 11007, 236.01),
('status_quo_2012', 777.94, 11008, 88.81),
('status_quo_2012', 1749.53, 11009, 199.72),
('status_quo_2012', 2446.93, 11010, 279.33),
('status_quo_2012', 1703.54, 11011, 194.47),
('status_quo_2012', 4513.74, 11012, 515.27),
('status_quo_2012', 2961.22, 11013, 338.04),
('status_quo_2012', 4822.74, 11014, 550.54),
('status_quo_2012', 4041.36, 11015, 461.34),
('status_quo_2012', 1680.35, 11016, 191.82),
('status_quo_2012', 4161.18, 11017, 475.02),
('status_quo_2012', 4267.31, 11018, 487.14),
('status_quo_2012', 700.80, 12000, 80.00),
('status_quo_2012', 175.20, 13000, 20.00),
('status_quo_2012', 87.60, 14000, 10.00),
('status_quo_2012', 0.00, 15000, 0.00),
('status_quo_2012', 15417.60, 16000, 1760.00),
('status_quo_2012', 28119.60, 17000, 3210.00),
('status_quo_2012', 5518.80, 18000, 630.00),
('status_quo_2012', 963.60, 19000, 110.00),
('status_quo_2012', 0.00, 20000, 48.00),
('status_quo_2012', 0.00, 21000, 1278.00),
('status_quo_2012', 0.00, 22000, 1115.00),
('status_quo_2012', 0.00, 23000, 320.00),
('status_quo_2012', 0.00, 24000, 427.00),
('UBA_2050_Regionenverbund', 8570.00, 11001, 3799.00),
('UBA_2050_Regionenverbund', 113.00, 11002, 50.00),
('UBA_2050_Regionenverbund', 3810.00, 11003, 1689.00),
('UBA_2050_Regionenverbund', 3603.00, 11004, 1597.00),
('UBA_2050_Regionenverbund', 1185.00, 11005, 525.00),
('UBA_2050_Regionenverbund', 1569.00, 11006, 696.00),
('UBA_2050_Regionenverbund', 1636.00, 11007, 725.00),
('UBA_2050_Regionenverbund', 1756.00, 11008, 779.00),
('UBA_2050_Regionenverbund', 3141.00, 11009, 1393.00),
('UBA_2050_Regionenverbund', 1602.00, 11010, 710.00),
('UBA_2050_Regionenverbund', 1250.00, 11011, 554.00),
('UBA_2050_Regionenverbund', 4112.00, 11012, 1823.00),
('UBA_2050_Regionenverbund', 2359.00, 11013, 1046.00),
('UBA_2050_Regionenverbund', 3101.00, 11014, 1375.00),
('UBA_2050_Regionenverbund', 3265.00, 11015, 1447.00),
('UBA_2050_Regionenverbund', 2921.00, 11016, 1295.00),
('UBA_2050_Regionenverbund', 4599.00, 11017, 2039.00),
('UBA_2050_Regionenverbund', 3967.00, 11018, 1758.00);

-- --------------------------------------------------------

--
-- Table structure for table `demand_scenario`
--

CREATE TABLE IF NOT EXISTS `demand_scenario` (
  `scenario_name` varchar(30) NOT NULL DEFAULT '',
  `base_year` text,
  `region_id` int(20) NOT NULL DEFAULT '0',
  `demand_change` double DEFAULT NULL COMMENT 'factor of change, 1 = no change',
  `min_self_supply` double DEFAULT NULL COMMENT '[MW] should not be higher than the demand in this region',
  PRIMARY KEY (`scenario_name`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `demand_scenario`
--

INSERT INTO `demand_scenario` (`scenario_name`, `base_year`, `region_id`, `demand_change`, `min_self_supply`) VALUES
('status_quo_2010', '2010', 11001, 1, 0),
('status_quo_2010', '2010', 11002, 1, 0),
('status_quo_2010', '2010', 11003, 1, 0),
('status_quo_2010', '2010', 11004, 1, 0),
('status_quo_2010', '2010', 11005, 1, 0),
('status_quo_2010', '2010', 11006, 1, 0),
('status_quo_2010', '2010', 11007, 1, 0),
('status_quo_2010', '2010', 11008, 1, 0),
('status_quo_2010', '2010', 11009, 1, 0),
('status_quo_2010', '2010', 11010, 1, 0),
('status_quo_2010', '2010', 11011, 1, 0),
('status_quo_2010', '2010', 11012, 1, 0),
('status_quo_2010', '2010', 11013, 1, 0),
('status_quo_2010', '2010', 11014, 1, 0),
('status_quo_2010', '2010', 11015, 1, 0),
('status_quo_2010', '2010', 11016, 1, 0),
('status_quo_2010', '2010', 11017, 1, 0),
('status_quo_2010', '2010', 11018, 1, 0),
('status_quo_2010', '2010', 11019, 1, 0),
('status_quo_2010', '2010', 11020, 1, 0),
('status_quo_2010', '2010', 11021, 1, 0),
('status_quo_2010', '2010', 12000, 1, 0),
('status_quo_2010', '2010', 13000, 1, 0),
('status_quo_2010', '2010', 14000, 1, 0),
('status_quo_2010', '2010', 15000, 1, 0),
('status_quo_2010', '2010', 16000, 1, 0),
('status_quo_2010', '2010', 17000, 1, 0),
('status_quo_2010', '2010', 18000, 1, 0),
('status_quo_2010', '2010', 19000, 1, 0),
('status_quo_2010', '2010', 20000, 1, 0),
('status_quo_2010', '2010', 21000, 1, 0),
('status_quo_2010', '2010', 22000, 1, 0),
('status_quo_2010', '2010', 23000, 1, 0),
('status_quo_2010', '2010', 24000, 1, 0),
('status_quo_2010', '2010', 25000, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `geothermal_scenario`
--

CREATE TABLE IF NOT EXISTS `geothermal_scenario` (
  `scenario_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `utilisation_factor` decimal(3,3) NOT NULL COMMENT '1 matches 100%',
  `region_id` int(8) NOT NULL DEFAULT '0',
  `installed_capacity` decimal(10,2) DEFAULT NULL COMMENT '[MW] including the already installed capacities',
  PRIMARY KEY (`scenario_name`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `geothermal_scenario`
--

INSERT INTO `geothermal_scenario` (`scenario_name`, `utilisation_factor`, `region_id`, `installed_capacity`) VALUES
('NEP_2024_A', 0.900, 11001, 4.00),
('NEP_2024_A', 0.900, 11009, 126.00),
('NEP_2024_A', 0.900, 11011, 9.00),
('NEP_2024_A', 0.900, 11018, 61.00),
('NEP_2024_B', 0.900, 11001, 4.00),
('NEP_2024_B', 0.900, 11009, 126.00),
('NEP_2024_B', 0.900, 11011, 9.00),
('NEP_2024_B', 0.900, 11018, 61.00),
('NEP_2024_C', 0.900, 11001, 23.00),
('NEP_2024_C', 0.900, 11009, 822.00),
('NEP_2024_C', 0.900, 11011, 58.00),
('NEP_2024_C', 0.900, 11018, 397.00),
('NEP_2034_B', 0.900, 11001, 4.00),
('NEP_2034_B', 0.900, 11009, 126.00),
('NEP_2034_B', 0.900, 11011, 9.00),
('NEP_2034_B', 0.900, 11018, 61.00),
('status_quo_2012', 0.900, 11001, 0.22),
('status_quo_2012', 0.900, 11009, 7.80),
('status_quo_2012', 0.900, 11011, 0.55),
('status_quo_2012', 0.900, 11018, 3.77),
('UBA_2050_Regionenverbund', 0.900, 11001, 114.00),
('UBA_2050_Regionenverbund', 0.900, 11009, 4045.00),
('UBA_2050_Regionenverbund', 0.900, 11011, 285.00),
('UBA_2050_Regionenverbund', 0.900, 11018, 1955.00);

-- --------------------------------------------------------

--
-- Table structure for table `grid_scenario`
--

CREATE TABLE IF NOT EXISTS `grid_scenario` (
  `scenario_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `plus_region_id` double NOT NULL DEFAULT '0',
  `minus_region_id` double NOT NULL DEFAULT '0',
  `voltage` int(10) NOT NULL DEFAULT '0' COMMENT '[kV]',
  `kind_of_current` varchar(10) CHARACTER SET utf8 DEFAULT '''ac'',''dc''' COMMENT 'ac or dc',
  `circuits` int(10) DEFAULT NULL COMMENT '[ ] either circuits or capacity have to be filled',
  `capacity` int(10) DEFAULT NULL COMMENT '[MW ] either circuits or capacity have to be filled',
  `kind_of_laying` text CHARACTER SET utf8 COMMENT 'land or sea',
  `distance` int(11) DEFAULT NULL COMMENT '[km] either distance or grid_loss have to be filled',
  `grid_loss` decimal(3,2) DEFAULT NULL COMMENT '[ ] 0.03 is the standard value and means 3% grid_loss per connection between two regions',
  PRIMARY KEY (`scenario_name`,`plus_region_id`,`minus_region_id`,`voltage`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `grid_scenario`
--

INSERT INTO `grid_scenario` (`scenario_name`, `plus_region_id`, `minus_region_id`, `voltage`, `kind_of_current`, `circuits`, `capacity`, `kind_of_laying`, `distance`, `grid_loss`) VALUES
('planned_2015', 11001, 11003, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11001, 11004, 220, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11001, 11004, 380, 'ac', 4, 0, 'land', 0, 0.03),
('planned_2015', 11001, 11013, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11001, 11015, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11001, 12000, 220, 'ac', 2, 804, 'land', 400, 0.03),
('planned_2015', 11001, 18000, 400, 'dc', 1, 600, 'sea', 166, 0.03),
('planned_2015', 11002, 11013, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11002, 11014, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11003, 11004, 220, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11003, 11004, 380, 'ac', 6, 0, 'land', 0, 0.03),
('planned_2015', 11003, 11016, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11003, 11017, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11004, 12000, 380, 'ac', 2, 2604, 'land', 400, 0.03),
('planned_2015', 11005, 11006, 220, 'ac', 1, 0, 'land', 0, 0.03),
('planned_2015', 11005, 11006, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11005, 11007, 220, 'ac', 1, 0, 'land', 0, 0.03),
('planned_2015', 11005, 11007, 380, 'ac', 1, 0, 'land', 0, 0.03),
('planned_2015', 11005, 11014, 380, 'ac', 4, 0, 'land', 0, 0.03),
('planned_2015', 11005, 11015, 220, 'ac', 1, 0, 'land', 0, 0.03),
('planned_2015', 11006, 11007, 220, 'ac', 1, 0, 'land', 0, 0.03),
('planned_2015', 11006, 11007, 380, 'ac', 6, 0, 'land', 0, 0.03),
('planned_2015', 11006, 11008, 380, 'ac', 6, 0, 'land', 0, 0.03),
('planned_2015', 11007, 11008, 220, 'ac', 1, 0, 'land', 0, 0.03),
('planned_2015', 11007, 11008, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11007, 11015, 380, 'ac', 4, 0, 'land', 0, 0.03),
('planned_2015', 11007, 11016, 380, 'ac', 4, 0, 'land', 0, 0.03),
('planned_2015', 11008, 11009, 220, 'ac', 3, 0, 'land', 0, 0.03),
('planned_2015', 11008, 11009, 380, 'ac', 5, 0, 'land', 0, 0.03),
('planned_2015', 11008, 11016, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11009, 11011, 220, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11009, 11011, 380, 'ac', 7, 0, 'land', 0, 0.03),
('planned_2015', 11009, 11016, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11009, 11017, 220, 'ac', 1, 0, 'land', 0, 0.03),
('planned_2015', 11010, 11012, 380, 'ac', 4, 0, 'land', 0, 0.03),
('planned_2015', 11010, 11018, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11011, 11012, 220, 'ac', 1, 0, 'land', 0, 0.03),
('planned_2015', 11011, 11012, 380, 'ac', 9, 0, 'land', 0, 0.03),
('planned_2015', 11011, 11017, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11013, 11014, 220, 'ac', 1, 0, 'land', 0, 0.03),
('planned_2015', 11013, 11014, 380, 'ac', 4, 0, 'land', 0, 0.03),
('planned_2015', 11013, 17000, 450, 'dc', 1, 600, 'sea', 270, 0.03),
('planned_2015', 11013, 18000, 110, 'ac', 1, 150, 'land', 350, 0.03),
('planned_2015', 11013, 18000, 220, 'ac', 2, 525, 'land', 350, 0.03),
('planned_2015', 11013, 18000, 380, 'ac', 2, 975, 'land', 350, 0.03),
('planned_2015', 11014, 11015, 220, 'ac', 1, 0, 'land', 0, 0.03),
('planned_2015', 11014, 11015, 380, 'ac', 5, 0, 'land', 0, 0.03),
('planned_2015', 11015, 11016, 220, 'ac', 1, 0, 'land', 0, 0.03),
('planned_2015', 11015, 11016, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11016, 11017, 220, 'ac', 1, 0, 'land', 0, 0.03),
('planned_2015', 11016, 11017, 380, 'ac', 2, 0, 'land', 0, 0.03),
('planned_2015', 11017, 11018, 220, 'ac', 3, 0, 'land', 0, 0.03),
('planned_2015', 11017, 11018, 380, 'ac', 3, 0, 'land', 0, 0.03),
('planned_2015', 12000, 13000, 400, 'ac', 2, 1000, 'land', 300, 0.03),
('planned_2015', 12000, 17000, 450, 'dc', 1, 600, 'sea', 256, 0.03),
('planned_2015', 13000, 14000, 110, 'ac', 3, 450, 'land', 125, 0.03),
('planned_2015', 13000, 14000, 330, 'ac', 4, 1500, 'land', 125, 0.03),
('planned_2015', 13000, 17000, 300, 'dc', 1, 700, 'sea', 400, 0.03),
('planned_2015', 14000, 15000, 110, 'ac', 2, 300, 'land', 130, 0.03),
('planned_2015', 14000, 15000, 330, 'ac', 2, 750, 'land', 130, 0.03),
('planned_2015', 15000, 16000, 150, 'dc', 1, 350, 'sea', 105, 0.03),
('planned_2015', 15000, 16000, 450, 'dc', 1, 650, 'sea', 171, 0.03),
('planned_2015', 16000, 17000, 110, 'ac', 1, 80, 'land', 550, 0.03),
('planned_2015', 16000, 17000, 220, 'ac', 1, 260, 'land', 550, 0.03),
('planned_2015', 16000, 17000, 380, 'ac', 2, 940, 'land', 550, 0.03),
('planned_2015', 16000, 17000, 400, 'dc', 1, 550, 'sea', 233, 0.03),
('planned_2015', 16000, 17000, 500, 'dc', 1, 800, 'sea', 233, 0.03),
('planned_2015', 16000, 19000, 220, 'ac', 1, 100, 'land', 700, 0.03),
('planned_2015', 17000, 18000, 110, 'ac', 2, 335, 'sea', 5, 0.03),
('planned_2015', 17000, 18000, 285, 'dc', 2, 740, 'sea', 60, 0.03),
('planned_2015', 17000, 18000, 380, 'ac', 2, 1015, 'sea', 5, 0.03),
('planned_2015', 17000, 19000, 110, 'ac', 3, 270, 'land', 150, 0.03),
('planned_2015', 17000, 19000, 220, 'ac', 1, 212, 'land', 150, 0.03),
('planned_2015', 17000, 19000, 380, 'ac', 4, 3340, 'land', 150, 0.03),
('planned_2015', 18000, 19000, 250, 'dc', 2, 500, 'sea', 85, 0.03),
('planned_2015', 18000, 19000, 350, 'dc', 1, 500, 'sea', 85, 0.03),
('planned_2015', 18000, 19000, 500, 'dc', 1, 700, 'sea', 85, 0.03),
('planned_2015_distance', 11001, 11003, 380, 'ac', 2, 0, 'land', 488, 0.00),
('planned_2015_distance', 11001, 11004, 220, 'ac', 2, 0, 'land', 583, 0.00),
('planned_2015_distance', 11001, 11004, 380, 'ac', 4, 0, 'land', 583, 0.00),
('planned_2015_distance', 11001, 11013, 380, 'ac', 2, 0, 'land', 421, 0.00),
('planned_2015_distance', 11001, 11015, 380, 'ac', 2, 0, 'land', 234, 0.00),
('planned_2015_distance', 11001, 12000, 220, 'ac', 2, 804, 'land', 464, 0.00),
('planned_2015_distance', 11001, 18000, 400, 'dc', 1, 600, 'sea', 401, 0.00),
('planned_2015_distance', 11002, 11013, 380, 'ac', 2, 0, 'land', 780, 0.00),
('planned_2015_distance', 11002, 11014, 380, 'ac', 2, 0, 'land', 739, 0.00),
('planned_2015_distance', 11003, 11004, 220, 'ac', 2, 0, 'land', 104, 0.00),
('planned_2015_distance', 11003, 11004, 380, 'ac', 6, 0, 'land', 104, 0.00),
('planned_2015_distance', 11003, 11016, 380, 'ac', 2, 0, 'land', 382, 0.00),
('planned_2015_distance', 11003, 11017, 380, 'ac', 2, 0, 'land', 374, 0.00),
('planned_2015_distance', 11004, 12000, 380, 'ac', 2, 2604, 'land', 850, 0.00),
('planned_2015_distance', 11005, 11006, 220, 'ac', 1, 0, 'land', 128, 0.00),
('planned_2015_distance', 11005, 11006, 380, 'ac', 2, 0, 'land', 128, 0.00),
('planned_2015_distance', 11005, 11007, 220, 'ac', 1, 0, 'land', 199, 0.00),
('planned_2015_distance', 11005, 11007, 380, 'ac', 1, 0, 'land', 199, 0.00),
('planned_2015_distance', 11005, 11014, 380, 'ac', 4, 0, 'land', 215, 0.00),
('planned_2015_distance', 11005, 11015, 220, 'ac', 1, 0, 'land', 354, 0.00),
('planned_2015_distance', 11006, 11007, 220, 'ac', 1, 0, 'land', 124, 0.00),
('planned_2015_distance', 11006, 11007, 380, 'ac', 6, 0, 'land', 124, 0.00),
('planned_2015_distance', 11006, 11008, 380, 'ac', 6, 0, 'land', 257, 0.00),
('planned_2015_distance', 11007, 11008, 220, 'ac', 1, 0, 'land', 169, 0.00),
('planned_2015_distance', 11007, 11008, 380, 'ac', 2, 0, 'land', 169, 0.00),
('planned_2015_distance', 11007, 11015, 380, 'ac', 4, 0, 'land', 169, 0.00),
('planned_2015_distance', 11007, 11016, 380, 'ac', 4, 0, 'land', 276, 0.00),
('planned_2015_distance', 11008, 11009, 220, 'ac', 3, 0, 'land', 191, 0.00),
('planned_2015_distance', 11008, 11009, 380, 'ac', 5, 0, 'land', 191, 0.00),
('planned_2015_distance', 11008, 11016, 380, 'ac', 2, 0, 'land', 301, 0.00),
('planned_2015_distance', 11009, 11011, 220, 'ac', 2, 0, 'land', 545, 0.00),
('planned_2015_distance', 11009, 11011, 380, 'ac', 7, 0, 'land', 545, 0.00),
('planned_2015_distance', 11009, 11016, 380, 'ac', 2, 0, 'land', 247, 0.00),
('planned_2015_distance', 11009, 11017, 220, 'ac', 1, 0, 'land', 394, 0.00),
('planned_2015_distance', 11010, 11012, 380, 'ac', 4, 0, 'land', 600, 0.00),
('planned_2015_distance', 11010, 11018, 380, 'ac', 2, 0, 'land', 525, 0.00),
('planned_2015_distance', 11011, 11012, 220, 'ac', 1, 0, 'land', 205, 0.00),
('planned_2015_distance', 11011, 11012, 380, 'ac', 9, 0, 'land', 205, 0.00),
('planned_2015_distance', 11011, 11017, 380, 'ac', 2, 0, 'land', 407, 0.00),
('planned_2015_distance', 11013, 11014, 220, 'ac', 1, 0, 'land', 70, 0.00),
('planned_2015_distance', 11013, 11014, 380, 'ac', 4, 0, 'land', 70, 0.00),
('planned_2015_distance', 11013, 17000, 450, 'dc', 1, 600, 'sea', 1043, 0.00),
('planned_2015_distance', 11013, 18000, 110, 'ac', 1, 150, 'land', 190, 0.00),
('planned_2015_distance', 11013, 18000, 220, 'ac', 2, 525, 'land', 190, 0.00),
('planned_2015_distance', 11013, 18000, 380, 'ac', 2, 975, 'land', 190, 0.00),
('planned_2015_distance', 11014, 11015, 220, 'ac', 1, 0, 'land', 480, 0.00),
('planned_2015_distance', 11014, 11015, 380, 'ac', 5, 0, 'land', 480, 0.00),
('planned_2015_distance', 11015, 11016, 220, 'ac', 1, 0, 'land', 156, 0.00),
('planned_2015_distance', 11015, 11016, 380, 'ac', 2, 0, 'land', 156, 0.00),
('planned_2015_distance', 11016, 11017, 220, 'ac', 1, 0, 'land', 427, 0.00),
('planned_2015_distance', 11016, 11017, 380, 'ac', 2, 0, 'land', 427, 0.00),
('planned_2015_distance', 11017, 11018, 220, 'ac', 3, 0, 'land', 119, 0.00),
('planned_2015_distance', 11017, 11018, 380, 'ac', 3, 0, 'land', 119, 0.00),
('planned_2015_distance', 12000, 13000, 400, 'ac', 2, 1000, 'land', 464, 0.00),
('planned_2015_distance', 12000, 17000, 450, 'dc', 1, 600, 'sea', 1203, 0.00),
('planned_2015_distance', 13000, 14000, 110, 'ac', 3, 450, 'land', 181, 0.00),
('planned_2015_distance', 13000, 14000, 330, 'ac', 4, 1500, 'land', 181, 0.00),
('planned_2015_distance', 13000, 17000, 300, 'dc', 1, 700, 'sea', 929, 0.00),
('planned_2015_distance', 14000, 15000, 110, 'ac', 2, 300, 'land', 211, 0.00),
('planned_2015_distance', 14000, 15000, 330, 'ac', 2, 750, 'land', 211, 0.00),
('planned_2015_distance', 15000, 16000, 150, 'dc', 1, 350, 'sea', 651, 0.00),
('planned_2015_distance', 15000, 16000, 450, 'dc', 1, 650, 'sea', 651, 0.00),
('planned_2015_distance', 16000, 17000, 110, 'ac', 1, 80, 'land', 507, 0.00),
('planned_2015_distance', 16000, 17000, 220, 'ac', 1, 260, 'land', 507, 0.00),
('planned_2015_distance', 16000, 17000, 380, 'ac', 2, 940, 'land', 507, 0.00),
('planned_2015_distance', 16000, 17000, 400, 'dc', 1, 550, 'sea', 507, 0.00),
('planned_2015_distance', 16000, 17000, 500, 'dc', 1, 800, 'sea', 507, 0.00),
('planned_2015_distance', 16000, 19000, 220, 'ac', 1, 100, 'land', 592, 0.00),
('planned_2015_distance', 17000, 18000, 110, 'ac', 2, 335, 'sea', 865, 0.00),
('planned_2015_distance', 17000, 18000, 285, 'dc', 2, 740, 'sea', 865, 0.00),
('planned_2015_distance', 17000, 18000, 380, 'ac', 2, 1015, 'sea', 865, 0.00),
('planned_2015_distance', 17000, 19000, 110, 'ac', 3, 270, 'land', 208, 0.00),
('planned_2015_distance', 17000, 19000, 220, 'ac', 1, 212, 'land', 208, 0.00),
('planned_2015_distance', 17000, 19000, 380, 'ac', 4, 3340, 'land', 208, 0.00),
('planned_2015_distance', 18000, 19000, 250, 'dc', 2, 500, 'sea', 949, 0.00),
('planned_2015_distance', 18000, 19000, 350, 'dc', 1, 500, 'sea', 949, 0.00),
('planned_2015_distance', 18000, 19000, 500, 'dc', 1, 700, 'sea', 949, 0.00),
('status_quo_2012', 11001, 11003, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11001, 11004, 220, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11001, 11004, 380, 'ac', 4, 0, 'land', 0, 0.03),
('status_quo_2012', 11001, 11013, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11001, 11015, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11001, 12000, 220, 'ac', 2, 804, 'land', 400, 0.03),
('status_quo_2012', 11001, 18000, 400, 'dc', 1, 600, 'sea', 166, 0.03),
('status_quo_2012', 11002, 11013, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11002, 11014, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11003, 11004, 220, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11003, 11004, 380, 'ac', 6, 0, 'land', 0, 0.03),
('status_quo_2012', 11003, 11016, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11003, 11017, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11004, 12000, 380, 'ac', 2, 2604, 'land', 400, 0.03),
('status_quo_2012', 11004, 25000, 380, 'ac', 2, 1240, 'land', NULL, 0.03),
('status_quo_2012', 11005, 11006, 220, 'ac', 1, 0, 'land', 0, 0.03),
('status_quo_2012', 11005, 11006, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11005, 11007, 220, 'ac', 1, 0, 'land', 0, 0.03),
('status_quo_2012', 11005, 11007, 380, 'ac', 1, 0, 'land', 0, 0.03),
('status_quo_2012', 11005, 11014, 380, 'ac', 4, 0, 'land', 0, 0.03),
('status_quo_2012', 11005, 11015, 220, 'ac', 1, 0, 'land', 0, 0.03),
('status_quo_2012', 11006, 11007, 220, 'ac', 1, 0, 'land', 0, 0.03),
('status_quo_2012', 11006, 11007, 380, 'ac', 6, 0, 'land', 0, 0.03),
('status_quo_2012', 11006, 11008, 380, 'ac', 6, 0, 'land', 0, 0.03),
('status_quo_2012', 11006, 20000, 380, 'ac', 4, 2533, 'land', NULL, 0.03),
('status_quo_2012', 11007, 11008, 220, 'ac', 1, 0, 'land', 0, 0.03),
('status_quo_2012', 11007, 11008, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11007, 11015, 380, 'ac', 4, 0, 'land', 0, 0.03),
('status_quo_2012', 11007, 11016, 380, 'ac', 4, 0, 'land', 0, 0.03),
('status_quo_2012', 11008, 11009, 220, 'ac', 3, 0, 'land', 0, 0.03),
('status_quo_2012', 11008, 11009, 380, 'ac', 5, 0, 'land', 0, 0.03),
('status_quo_2012', 11008, 11016, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11009, 11011, 220, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11009, 11011, 380, 'ac', 7, 0, 'land', 0, 0.03),
('status_quo_2012', 11009, 11016, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11009, 11017, 220, 'ac', 1, 0, 'land', 0, 0.03),
('status_quo_2012', 11009, 21000, 220, 'ac', 4, 980, 'land', NULL, 0.03),
('status_quo_2012', 11009, 22000, 220, 'ac', 1, 214, 'land', NULL, 0.03),
('status_quo_2012', 11009, 22000, 380, 'ac', 2, 857, 'land', NULL, 0.03),
('status_quo_2012', 11010, 11012, 380, 'ac', 4, 0, 'land', 0, 0.03),
('status_quo_2012', 11010, 11018, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11010, 24000, 220, 'ac', 1, 137, 'land', NULL, 0.03),
('status_quo_2012', 11010, 24000, 380, 'ac', 5, 1375, 'land', NULL, 0.03),
('status_quo_2012', 11011, 11012, 220, 'ac', 1, 0, 'land', 0, 0.03),
('status_quo_2012', 11011, 11012, 380, 'ac', 9, 0, 'land', 0, 0.03),
('status_quo_2012', 11011, 11017, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11012, 22000, 220, 'ac', 1, 214, 'land', NULL, 0.03),
('status_quo_2012', 11012, 22000, 380, 'ac', 4, 1714, 'land', NULL, 0.03),
('status_quo_2012', 11012, 23000, 380, 'ac', 7, 3500, 'land', NULL, 0.03),
('status_quo_2012', 11013, 11014, 220, 'ac', 1, 0, 'land', 0, 0.03),
('status_quo_2012', 11013, 11014, 380, 'ac', 4, 0, 'land', 0, 0.03),
('status_quo_2012', 11013, 17000, 450, 'dc', 1, 600, 'sea', 270, 0.03),
('status_quo_2012', 11013, 18000, 110, 'ac', 1, 150, 'land', 350, 0.03),
('status_quo_2012', 11013, 18000, 220, 'ac', 2, 525, 'land', 350, 0.03),
('status_quo_2012', 11013, 18000, 380, 'ac', 2, 975, 'land', 350, 0.03),
('status_quo_2012', 11014, 11015, 220, 'ac', 1, 0, 'land', 0, 0.03),
('status_quo_2012', 11014, 11015, 380, 'ac', 5, 0, 'land', 0, 0.03),
('status_quo_2012', 11014, 20000, 380, 'ac', 2, 1267, 'land', NULL, 0.03),
('status_quo_2012', 11015, 11016, 220, 'ac', 1, 0, 'land', 0, 0.03),
('status_quo_2012', 11015, 11016, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11016, 11017, 220, 'ac', 1, 0, 'land', 0, 0.03),
('status_quo_2012', 11016, 11017, 380, 'ac', 2, 0, 'land', 0, 0.03),
('status_quo_2012', 11017, 11018, 220, 'ac', 3, 0, 'land', 0, 0.03),
('status_quo_2012', 11017, 11018, 380, 'ac', 3, 0, 'land', 0, 0.03),
('status_quo_2012', 11017, 25000, 380, 'ac', 2, 1240, 'land', NULL, 0.03),
('status_quo_2012', 11018, 24000, 220, 'ac', 5, 688, 'land', NULL, 0.03),
('status_quo_2012', 12000, 17000, 450, 'dc', 1, 600, 'sea', 256, 0.03),
('status_quo_2012', 12000, 25000, 380, 'ac', NULL, 1800, 'land', NULL, 0.03),
('status_quo_2012', 13000, 14000, 110, 'ac', 3, 450, 'land', 125, 0.03),
('status_quo_2012', 13000, 14000, 330, 'ac', 4, 1500, 'land', 125, 0.03),
('status_quo_2012', 14000, 15000, 110, 'ac', 2, 300, 'land', 130, 0.03),
('status_quo_2012', 14000, 15000, 330, 'ac', 2, 750, 'land', 130, 0.03),
('status_quo_2012', 15000, 16000, 150, 'dc', 1, 350, 'sea', 105, 0.03),
('status_quo_2012', 16000, 17000, 110, 'ac', 1, 80, 'land', 550, 0.03),
('status_quo_2012', 16000, 17000, 220, 'ac', 1, 260, 'land', 550, 0.03),
('status_quo_2012', 16000, 17000, 380, 'ac', 2, 940, 'land', 550, 0.03),
('status_quo_2012', 16000, 17000, 400, 'dc', 1, 550, 'sea', 233, 0.03),
('status_quo_2012', 16000, 17000, 500, 'dc', 1, 800, 'sea', 233, 0.03),
('status_quo_2012', 16000, 19000, 220, 'ac', 1, 100, 'land', 700, 0.03),
('status_quo_2012', 17000, 18000, 110, 'ac', 2, 335, 'sea', 5, 0.03),
('status_quo_2012', 17000, 18000, 285, 'dc', 2, 740, 'sea', 60, 0.03),
('status_quo_2012', 17000, 18000, 380, 'ac', 2, 1015, 'sea', 5, 0.03),
('status_quo_2012', 17000, 19000, 110, 'ac', 3, 270, 'land', 150, 0.03),
('status_quo_2012', 17000, 19000, 220, 'ac', 1, 212, 'land', 150, 0.03),
('status_quo_2012', 17000, 19000, 380, 'ac', 4, 3340, 'land', 150, 0.03),
('status_quo_2012', 18000, 19000, 250, 'dc', 2, 500, 'sea', 85, 0.03),
('status_quo_2012', 18000, 19000, 350, 'dc', 1, 500, 'sea', 85, 0.03),
('status_quo_2012', 19000, 20000, 380, 'ac', NULL, 700, 'land', NULL, 0.03),
('status_quo_2012', 20000, 21000, 380, 'ac', NULL, 2400, 'land', NULL, 0.03),
('status_quo_2012', 21000, 22000, 380, 'ac', NULL, 3400, 'land', NULL, 0.03),
('status_quo_2012', 22000, 23000, 380, 'ac', NULL, 3200, 'land', NULL, 0.03),
('status_quo_2012', 23000, 24000, 380, 'ac', NULL, 1200, 'land', NULL, 0.03),
('status_quo_2012', 24000, 25000, 380, 'ac', NULL, 1000, 'land', NULL, 0.03),
('status_quo_2012_distance', 11001, 11003, 380, 'ac', 2, 0, 'land', 488, 0.00),
('status_quo_2012_distance', 11001, 11004, 220, 'ac', 2, 0, 'land', 583, 0.00),
('status_quo_2012_distance', 11001, 11004, 380, 'ac', 4, 0, 'land', 583, 0.00),
('status_quo_2012_distance', 11001, 11013, 380, 'ac', 2, 0, 'land', 421, 0.00),
('status_quo_2012_distance', 11001, 11015, 380, 'ac', 2, 0, 'land', 234, 0.00),
('status_quo_2012_distance', 11001, 12000, 220, 'ac', 2, 804, 'land', 464, 0.00),
('status_quo_2012_distance', 11001, 18000, 400, 'dc', 1, 600, 'sea', 401, 0.00),
('status_quo_2012_distance', 11002, 11013, 380, 'ac', 2, 0, 'land', 780, 0.00),
('status_quo_2012_distance', 11002, 11014, 380, 'ac', 2, 0, 'land', 739, 0.00),
('status_quo_2012_distance', 11003, 11004, 220, 'ac', 2, 0, 'land', 104, 0.00),
('status_quo_2012_distance', 11003, 11004, 380, 'ac', 6, 0, 'land', 104, 0.00),
('status_quo_2012_distance', 11003, 11016, 380, 'ac', 2, 0, 'land', 382, 0.00),
('status_quo_2012_distance', 11003, 11017, 380, 'ac', 2, 0, 'land', 374, 0.00),
('status_quo_2012_distance', 11004, 12000, 380, 'ac', 2, 2604, 'land', 850, 0.00),
('status_quo_2012_distance', 11004, 25000, 380, 'ac', 2, 1240, 'land', 486, 0.00),
('status_quo_2012_distance', 11005, 11006, 220, 'ac', 1, 0, 'land', 128, 0.00),
('status_quo_2012_distance', 11005, 11006, 380, 'ac', 2, 0, 'land', 128, 0.00),
('status_quo_2012_distance', 11005, 11007, 220, 'ac', 1, 0, 'land', 199, 0.00),
('status_quo_2012_distance', 11005, 11007, 380, 'ac', 1, 0, 'land', 199, 0.00),
('status_quo_2012_distance', 11005, 11014, 380, 'ac', 4, 0, 'land', 215, 0.00),
('status_quo_2012_distance', 11005, 11015, 220, 'ac', 1, 0, 'land', 354, 0.00),
('status_quo_2012_distance', 11006, 11007, 220, 'ac', 1, 0, 'land', 124, 0.00),
('status_quo_2012_distance', 11006, 11007, 380, 'ac', 6, 0, 'land', 124, 0.00),
('status_quo_2012_distance', 11006, 11008, 380, 'ac', 6, 0, 'land', 257, 0.00),
('status_quo_2012_distance', 11006, 20000, 380, 'ac', 4, 2533, 'land', 234, 0.00),
('status_quo_2012_distance', 11007, 11008, 220, 'ac', 1, 0, 'land', 169, 0.00),
('status_quo_2012_distance', 11007, 11008, 380, 'ac', 2, 0, 'land', 169, 0.00),
('status_quo_2012_distance', 11007, 11015, 380, 'ac', 4, 0, 'land', 169, 0.00),
('status_quo_2012_distance', 11007, 11016, 380, 'ac', 4, 0, 'land', 276, 0.00),
('status_quo_2012_distance', 11008, 11009, 220, 'ac', 3, 0, 'land', 191, 0.00),
('status_quo_2012_distance', 11008, 11009, 380, 'ac', 5, 0, 'land', 191, 0.00),
('status_quo_2012_distance', 11008, 11016, 380, 'ac', 2, 0, 'land', 301, 0.00),
('status_quo_2012_distance', 11009, 11011, 220, 'ac', 2, 0, 'land', 545, 0.00),
('status_quo_2012_distance', 11009, 11011, 380, 'ac', 7, 0, 'land', 545, 0.00),
('status_quo_2012_distance', 11009, 11016, 380, 'ac', 2, 0, 'land', 247, 0.00),
('status_quo_2012_distance', 11009, 11017, 220, 'ac', 1, 0, 'land', 394, 0.00),
('status_quo_2012_distance', 11009, 21000, 220, 'ac', 4, 980, 'land', 458, 0.00),
('status_quo_2012_distance', 11009, 22000, 220, 'ac', 1, 214, 'land', 721, 0.00),
('status_quo_2012_distance', 11009, 22000, 380, 'ac', 2, 857, 'land', 721, 0.00),
('status_quo_2012_distance', 11010, 11012, 380, 'ac', 4, 0, 'land', 600, 0.00),
('status_quo_2012_distance', 11010, 11018, 380, 'ac', 2, 0, 'land', 525, 0.00),
('status_quo_2012_distance', 11010, 24000, 220, 'ac', 1, 137, 'land', 164, 0.00),
('status_quo_2012_distance', 11010, 24000, 380, 'ac', 5, 1375, 'land', 164, 0.00),
('status_quo_2012_distance', 11011, 11012, 220, 'ac', 1, 0, 'land', 205, 0.00),
('status_quo_2012_distance', 11011, 11012, 380, 'ac', 9, 0, 'land', 205, 0.00),
('status_quo_2012_distance', 11011, 11017, 380, 'ac', 2, 0, 'land', 407, 0.00),
('status_quo_2012_distance', 11012, 22000, 220, 'ac', 1, 214, 'land', 940, 0.00),
('status_quo_2012_distance', 11012, 22000, 380, 'ac', 4, 1714, 'land', 940, 0.00),
('status_quo_2012_distance', 11012, 23000, 380, 'ac', 7, 3500, 'land', 761, 0.00),
('status_quo_2012_distance', 11013, 11014, 220, 'ac', 1, 0, 'land', 70, 0.00),
('status_quo_2012_distance', 11013, 11014, 380, 'ac', 4, 0, 'land', 70, 0.00),
('status_quo_2012_distance', 11013, 17000, 450, 'dc', 1, 600, 'sea', 1043, 0.00),
('status_quo_2012_distance', 11013, 18000, 110, 'ac', 1, 150, 'land', 190, 0.00),
('status_quo_2012_distance', 11013, 18000, 220, 'ac', 2, 525, 'land', 190, 0.00),
('status_quo_2012_distance', 11013, 18000, 380, 'ac', 2, 975, 'land', 190, 0.00),
('status_quo_2012_distance', 11014, 11015, 220, 'ac', 1, 0, 'land', 480, 0.00),
('status_quo_2012_distance', 11014, 11015, 380, 'ac', 5, 0, 'land', 480, 0.00),
('status_quo_2012_distance', 11014, 20000, 380, 'ac', 2, 1267, 'land', 238, 0.00),
('status_quo_2012_distance', 11015, 11016, 220, 'ac', 1, 0, 'land', 156, 0.00),
('status_quo_2012_distance', 11015, 11016, 380, 'ac', 2, 0, 'land', 156, 0.00),
('status_quo_2012_distance', 11016, 11017, 220, 'ac', 1, 0, 'land', 427, 0.00),
('status_quo_2012_distance', 11016, 11017, 380, 'ac', 2, 0, 'land', 427, 0.00),
('status_quo_2012_distance', 11017, 11018, 220, 'ac', 3, 0, 'land', 119, 0.00),
('status_quo_2012_distance', 11017, 11018, 380, 'ac', 3, 0, 'land', 119, 0.00),
('status_quo_2012_distance', 11017, 25000, 380, 'ac', 2, 1240, 'land', 621, 0.00),
('status_quo_2012_distance', 11018, 24000, 220, 'ac', 5, 688, 'land', 686, 0.00),
('status_quo_2012_distance', 12000, 17000, 450, 'dc', 1, 600, 'sea', 1203, 0.00),
('status_quo_2012_distance', 12000, 25000, 380, 'ac', NULL, 1800, 'land', 390, 0.00),
('status_quo_2012_distance', 13000, 14000, 110, 'ac', 3, 450, 'land', 181, 0.00),
('status_quo_2012_distance', 13000, 14000, 330, 'ac', 4, 1500, 'land', 181, 0.00),
('status_quo_2012_distance', 14000, 15000, 110, 'ac', 2, 300, 'land', 211, 0.00),
('status_quo_2012_distance', 14000, 15000, 330, 'ac', 2, 750, 'land', 211, 0.00),
('status_quo_2012_distance', 15000, 16000, 150, 'dc', 1, 350, 'sea', 651, 0.00),
('status_quo_2012_distance', 16000, 17000, 110, 'ac', 1, 80, 'land', 507, 0.00),
('status_quo_2012_distance', 16000, 17000, 220, 'ac', 1, 260, 'land', 507, 0.00),
('status_quo_2012_distance', 16000, 17000, 380, 'ac', 2, 940, 'land', 507, 0.00),
('status_quo_2012_distance', 16000, 17000, 400, 'dc', 1, 550, 'sea', 507, 0.00),
('status_quo_2012_distance', 16000, 17000, 500, 'dc', 1, 800, 'sea', 507, 0.00),
('status_quo_2012_distance', 16000, 19000, 220, 'ac', 1, 100, 'land', 592, 0.00),
('status_quo_2012_distance', 17000, 18000, 110, 'ac', 2, 335, 'sea', 865, 0.00),
('status_quo_2012_distance', 17000, 18000, 285, 'dc', 2, 740, 'sea', 865, 0.00),
('status_quo_2012_distance', 17000, 18000, 380, 'ac', 2, 1015, 'sea', 865, 0.00),
('status_quo_2012_distance', 17000, 19000, 110, 'ac', 3, 270, 'land', 208, 0.00),
('status_quo_2012_distance', 17000, 19000, 220, 'ac', 1, 212, 'land', 208, 0.00),
('status_quo_2012_distance', 17000, 19000, 380, 'ac', 4, 3340, 'land', 208, 0.00),
('status_quo_2012_distance', 18000, 19000, 250, 'dc', 2, 500, 'sea', 949, 0.00),
('status_quo_2012_distance', 18000, 19000, 350, 'dc', 1, 500, 'sea', 949, 0.00),
('status_quo_2012_distance', 19000, 20000, 380, 'ac', NULL, 700, 'land', 1417, 0.00),
('status_quo_2012_distance', 20000, 21000, 380, 'ac', NULL, 2400, 'land', 197, 0.00),
('status_quo_2012_distance', 21000, 22000, 380, 'ac', NULL, 3400, 'land', 471, 0.00),
('status_quo_2012_distance', 22000, 23000, 380, 'ac', NULL, 3200, 'land', 441, 0.00),
('status_quo_2012_distance', 23000, 24000, 380, 'ac', NULL, 1200, 'land', 454, 0.00),
('status_quo_2012_distance', 24000, 25000, 380, 'ac', NULL, 1000, 'land', 255, 0.00);

-- --------------------------------------------------------

--
-- Table structure for table `hydro_storage_scenario`
--

CREATE TABLE IF NOT EXISTS `hydro_storage_scenario` (
  `scenario_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `region_id` int(1) NOT NULL DEFAULT '0',
  `capacity` int(6) DEFAULT NULL COMMENT 'MW',
  PRIMARY KEY (`scenario_name`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hydro_storage_scenario`
--

INSERT INTO `hydro_storage_scenario` (`scenario_name`, `region_id`, `capacity`) VALUES
('NEP_2023_ABC', 11003, 2720),
('NEP_2023_ABC', 11004, 1853),
('NEP_2023_ABC', 11006, 260),
('NEP_2023_ABC', 11007, 238),
('NEP_2023_ABC', 11012, 3403),
('NEP_2023_ABC', 11013, 204),
('NEP_2023_ABC', 11015, 418),
('NEP_2023_ABC', 11016, 1054),
('NEP_2023_ABC', 11017, 796),
('NEP_2023_ABC', 11018, 158),
('NEP_2023_ABC', 12000, 932),
('NEP_2023_ABC', 13000, 760),
('NEP_2023_ABC', 14000, 0),
('NEP_2023_ABC', 15000, 0),
('NEP_2023_ABC', 16000, 0),
('NEP_2023_ABC', 17000, 108),
('NEP_2023_ABC', 18000, 0),
('NEP_2023_ABC', 19000, 1353),
('plus_hydro_Norway10GW', 11003, 2400),
('plus_hydro_Norway10GW', 11004, 1635),
('plus_hydro_Norway10GW', 11006, 230),
('plus_hydro_Norway10GW', 11007, 210),
('plus_hydro_Norway10GW', 11012, 3003),
('plus_hydro_Norway10GW', 11013, 180),
('plus_hydro_Norway10GW', 11015, 369),
('plus_hydro_Norway10GW', 11016, 930),
('plus_hydro_Norway10GW', 11017, 702),
('plus_hydro_Norway10GW', 11018, 140),
('plus_hydro_Norway10GW', 12000, 2338),
('plus_hydro_Norway10GW', 13000, 875),
('plus_hydro_Norway10GW', 14000, 1536),
('plus_hydro_Norway10GW', 15000, 600),
('plus_hydro_Norway10GW', 16000, 3120),
('plus_hydro_Norway10GW', 17000, 16652),
('plus_hydro_Norway10GW', 18000, 0),
('plus_hydro_Norway10GW', 19000, 11353),
('status_quo_2012', 11003, 1600),
('status_quo_2012', 11004, 1090),
('status_quo_2012', 11006, 153),
('status_quo_2012', 11007, 140),
('status_quo_2012', 11012, 2002),
('status_quo_2012', 11013, 120),
('status_quo_2012', 11015, 246),
('status_quo_2012', 11016, 620),
('status_quo_2012', 11017, 468),
('status_quo_2012', 11018, 93),
('status_quo_2012', 12000, 1549),
('status_quo_2012', 13000, 900),
('status_quo_2012', 14000, 1455),
('status_quo_2012', 16000, 545),
('status_quo_2012', 17000, 8908),
('status_quo_2012', 19000, 1353),
('status_quo_2012', 21000, 2260),
('status_quo_2012', 22000, 18658),
('status_quo_2012', 23000, 9811),
('status_quo_2012', 24000, 9569),
('status_quo_2012', 25000, 1584);

-- --------------------------------------------------------

--
-- Table structure for table `other_storage_scenario`
--

CREATE TABLE IF NOT EXISTS `other_storage_scenario` (
  `scenario_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `region_id` int(1) NOT NULL DEFAULT '0',
  `capacity` int(6) DEFAULT NULL COMMENT 'MW',
  `energy` int(8) DEFAULT NULL COMMENT 'MWh',
  `efficiency` decimal(4,3) DEFAULT NULL COMMENT 'part of 1',
  PRIMARY KEY (`scenario_name`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `other_storage_scenario`
--

INSERT INTO `other_storage_scenario` (`scenario_name`, `region_id`, `capacity`, `energy`, `efficiency`) VALUES
('status_quo_2012', 11001, 0, 0, 0.800),
('status_quo_2012', 11002, 0, 0, 0.800),
('status_quo_2012', 11003, 0, 0, 0.800),
('status_quo_2012', 11004, 0, 0, 0.800),
('status_quo_2012', 11005, 0, 0, 0.800),
('status_quo_2012', 11006, 0, 0, 0.800),
('status_quo_2012', 11007, 0, 0, 0.800),
('status_quo_2012', 11008, 0, 0, 0.800),
('status_quo_2012', 11009, 0, 0, 0.800),
('status_quo_2012', 11010, 0, 0, 0.800),
('status_quo_2012', 11011, 0, 0, 0.800),
('status_quo_2012', 11012, 0, 0, 0.800),
('status_quo_2012', 11013, 0, 0, 0.800),
('status_quo_2012', 11014, 0, 0, 0.800),
('status_quo_2012', 11015, 0, 0, 0.800),
('status_quo_2012', 11016, 0, 0, 0.800),
('status_quo_2012', 11017, 0, 0, 0.800),
('status_quo_2012', 11018, 0, 0, 0.800),
('status_quo_2012', 11019, 0, 0, 0.800),
('status_quo_2012', 11020, 0, 0, 0.800),
('status_quo_2012', 11021, 0, 0, 0.800),
('status_quo_2012', 12000, 0, 0, 0.800),
('status_quo_2012', 13000, 0, 0, 0.800),
('status_quo_2012', 14000, 0, 0, 0.800),
('status_quo_2012', 15000, 0, 0, 0.800),
('status_quo_2012', 16000, 0, 0, 0.800),
('status_quo_2012', 17000, 0, 0, 0.800),
('status_quo_2012', 18000, 0, 0, 0.800),
('status_quo_2012', 19000, 0, 0, 0.800),
('status_quo_2012', 20000, 0, 0, 0.800),
('status_quo_2012', 21000, 0, 0, 0.800),
('status_quo_2012', 22000, 0, 0, 0.800),
('status_quo_2012', 23000, 0, 0, 0.800),
('status_quo_2012', 24000, 0, 0, 0.800);

-- --------------------------------------------------------

--
-- Table structure for table `region_scenario`
--

CREATE TABLE IF NOT EXISTS `region_scenario` (
  `scenario_name` varchar(50) NOT NULL,
  `region_id` int(9) NOT NULL,
  `dpr_number` int(10) NOT NULL COMMENT 'number from 1 to number of regions in this calculation / dispatch region number',
  PRIMARY KEY (`scenario_name`,`region_id`,`dpr_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `region_scenario`
--

INSERT INTO `region_scenario` (`scenario_name`, `region_id`, `dpr_number`) VALUES
('all_countries_no_split', 11001, 1),
('all_countries_no_split', 11002, 1),
('all_countries_no_split', 11003, 1),
('all_countries_no_split', 11004, 1),
('all_countries_no_split', 11005, 1),
('all_countries_no_split', 11006, 1),
('all_countries_no_split', 11007, 1),
('all_countries_no_split', 11008, 1),
('all_countries_no_split', 11009, 1),
('all_countries_no_split', 11010, 1),
('all_countries_no_split', 11011, 1),
('all_countries_no_split', 11012, 1),
('all_countries_no_split', 11013, 1),
('all_countries_no_split', 11014, 1),
('all_countries_no_split', 11015, 1),
('all_countries_no_split', 11016, 1),
('all_countries_no_split', 11017, 1),
('all_countries_no_split', 11018, 1),
('all_countries_no_split', 11019, 1),
('all_countries_no_split', 11020, 1),
('all_countries_no_split', 11021, 1),
('all_countries_no_split', 12000, 2),
('all_countries_no_split', 13000, 3),
('all_countries_no_split', 14000, 4),
('all_countries_no_split', 15000, 5),
('all_countries_no_split', 16000, 6),
('all_countries_no_split', 17000, 7),
('all_countries_no_split', 18000, 8),
('all_countries_no_split', 19000, 9),
('all_countries_no_split', 20000, 10),
('all_countries_no_split', 21000, 11),
('all_countries_no_split', 22000, 12),
('all_countries_no_split', 23000, 13),
('all_countries_no_split', 24000, 14),
('all_countries_no_split', 25000, 15),
('germany2', 11001, 1),
('germany2', 11002, 1),
('germany2', 11003, 1),
('germany2', 11004, 1),
('germany2', 11005, 1),
('germany2', 11006, 1),
('germany2', 11007, 1),
('germany2', 11008, 1),
('germany2', 11009, 2),
('germany2', 11010, 2),
('germany2', 11011, 2),
('germany2', 11012, 2),
('germany2', 11013, 1),
('germany2', 11014, 1),
('germany2', 11015, 1),
('germany2', 11016, 1),
('germany2', 11017, 2),
('germany2', 11018, 2),
('germany2', 11019, 1),
('germany2', 11020, 1),
('germany2', 11021, 1),
('germany21', 11001, 1),
('germany21', 11002, 2),
('germany21', 11003, 3),
('germany21', 11004, 4),
('germany21', 11005, 5),
('germany21', 11006, 6),
('germany21', 11007, 7),
('germany21', 11008, 8),
('germany21', 11009, 9),
('germany21', 11010, 10),
('germany21', 11011, 11),
('germany21', 11012, 12),
('germany21', 11013, 13),
('germany21', 11014, 14),
('germany21', 11015, 15),
('germany21', 11016, 16),
('germany21', 11017, 17),
('germany21', 11018, 18),
('germany21', 11019, 19),
('germany21', 11020, 20),
('germany21', 11021, 21),
('germany21_all_countries', 11001, 1),
('germany21_all_countries', 11002, 2),
('germany21_all_countries', 11003, 3),
('germany21_all_countries', 11004, 4),
('germany21_all_countries', 11005, 5),
('germany21_all_countries', 11006, 6),
('germany21_all_countries', 11007, 7),
('germany21_all_countries', 11008, 8),
('germany21_all_countries', 11009, 9),
('germany21_all_countries', 11010, 10),
('germany21_all_countries', 11011, 11),
('germany21_all_countries', 11012, 12),
('germany21_all_countries', 11013, 13),
('germany21_all_countries', 11014, 14),
('germany21_all_countries', 11015, 15),
('germany21_all_countries', 11016, 16),
('germany21_all_countries', 11017, 17),
('germany21_all_countries', 11018, 18),
('germany21_all_countries', 11019, 19),
('germany21_all_countries', 11020, 20),
('germany21_all_countries', 11021, 21),
('germany21_all_countries', 12000, 22),
('germany21_all_countries', 13000, 23),
('germany21_all_countries', 14000, 24),
('germany21_all_countries', 15000, 25),
('germany21_all_countries', 16000, 26),
('germany21_all_countries', 17000, 27),
('germany21_all_countries', 18000, 28),
('germany21_all_countries', 19000, 29),
('germany21_all_countries', 20000, 30),
('germany21_all_countries', 21000, 31),
('germany21_all_countries', 22000, 32),
('germany21_all_countries', 23000, 33),
('germany21_all_countries', 24000, 34),
('germany21_all_countries', 25000, 35),
('germany21_neighbours', 11001, 1),
('germany21_neighbours', 11002, 2),
('germany21_neighbours', 11003, 3),
('germany21_neighbours', 11004, 4),
('germany21_neighbours', 11005, 5),
('germany21_neighbours', 11006, 6),
('germany21_neighbours', 11007, 7),
('germany21_neighbours', 11008, 8),
('germany21_neighbours', 11009, 9),
('germany21_neighbours', 11010, 10),
('germany21_neighbours', 11011, 11),
('germany21_neighbours', 11012, 12),
('germany21_neighbours', 11013, 13),
('germany21_neighbours', 11014, 14),
('germany21_neighbours', 11015, 15),
('germany21_neighbours', 11016, 16),
('germany21_neighbours', 11017, 17),
('germany21_neighbours', 11018, 18),
('germany21_neighbours', 11019, 19),
('germany21_neighbours', 11020, 20),
('germany21_neighbours', 11021, 21),
('germany21_neighbours', 12000, 22),
('germany21_neighbours', 17000, 23),
('germany21_neighbours', 18000, 24),
('germany21_neighbours', 19000, 25),
('germany21_neighbours', 20000, 26),
('germany21_neighbours', 21000, 27),
('germany21_neighbours', 22000, 28),
('germany21_neighbours', 23000, 29),
('germany21_neighbours', 24000, 30),
('germany21_neighbours', 25000, 31),
('germany21_norway', 11001, 1),
('germany21_norway', 11002, 2),
('germany21_norway', 11003, 3),
('germany21_norway', 11004, 4),
('germany21_norway', 11005, 5),
('germany21_norway', 11006, 6),
('germany21_norway', 11007, 7),
('germany21_norway', 11008, 8),
('germany21_norway', 11009, 9),
('germany21_norway', 11010, 10),
('germany21_norway', 11011, 11),
('germany21_norway', 11012, 12),
('germany21_norway', 11013, 13),
('germany21_norway', 11014, 14),
('germany21_norway', 11015, 15),
('germany21_norway', 11016, 16),
('germany21_norway', 11017, 17),
('germany21_norway', 11018, 18),
('germany21_norway', 11019, 19),
('germany21_norway', 11020, 20),
('germany21_norway', 11021, 21),
('germany21_norway', 19000, 22),
('germany21_NO_AT_CH', 11001, 1),
('germany21_NO_AT_CH', 11002, 2),
('germany21_NO_AT_CH', 11003, 3),
('germany21_NO_AT_CH', 11004, 4),
('germany21_NO_AT_CH', 11005, 5),
('germany21_NO_AT_CH', 11006, 6),
('germany21_NO_AT_CH', 11007, 7),
('germany21_NO_AT_CH', 11008, 8),
('germany21_NO_AT_CH', 11009, 9),
('germany21_NO_AT_CH', 11010, 10),
('germany21_NO_AT_CH', 11011, 11),
('germany21_NO_AT_CH', 11012, 12),
('germany21_NO_AT_CH', 11013, 13),
('germany21_NO_AT_CH', 11014, 14),
('germany21_NO_AT_CH', 11015, 15),
('germany21_NO_AT_CH', 11016, 16),
('germany21_NO_AT_CH', 11017, 17),
('germany21_NO_AT_CH', 11018, 18),
('germany21_NO_AT_CH', 11019, 19),
('germany21_NO_AT_CH', 11020, 20),
('germany21_NO_AT_CH', 11021, 21),
('germany21_NO_AT_CH', 19000, 22),
('germany21_NO_AT_CH', 23000, 23),
('germany21_NO_AT_CH', 24000, 24),
('germany5', 11001, 2),
('germany5', 11002, 1),
('germany5', 11003, 2),
('germany5', 11004, 2),
('germany5', 11005, 1),
('germany5', 11006, 3),
('germany5', 11007, 3),
('germany5', 11008, 3),
('germany5', 11009, 4),
('germany5', 11010, 4),
('germany5', 11011, 4),
('germany5', 11012, 4),
('germany5', 11013, 1),
('germany5', 11014, 1),
('germany5', 11015, 1),
('germany5', 11016, 3),
('germany5', 11017, 5),
('germany5', 11018, 5),
('germany5', 11019, 2),
('germany5', 11020, 1),
('germany5', 11021, 1),
('germany5_all_countries', 11001, 2),
('germany5_all_countries', 11002, 1),
('germany5_all_countries', 11003, 2),
('germany5_all_countries', 11004, 2),
('germany5_all_countries', 11005, 1),
('germany5_all_countries', 11006, 3),
('germany5_all_countries', 11007, 3),
('germany5_all_countries', 11008, 3),
('germany5_all_countries', 11009, 4),
('germany5_all_countries', 11010, 4),
('germany5_all_countries', 11011, 4),
('germany5_all_countries', 11012, 4),
('germany5_all_countries', 11013, 1),
('germany5_all_countries', 11014, 1),
('germany5_all_countries', 11015, 1),
('germany5_all_countries', 11016, 3),
('germany5_all_countries', 11017, 5),
('germany5_all_countries', 11018, 5),
('germany5_all_countries', 11019, 2),
('germany5_all_countries', 11020, 1),
('germany5_all_countries', 11021, 1),
('germany5_all_countries', 12000, 6),
('germany5_all_countries', 13000, 7),
('germany5_all_countries', 14000, 8),
('germany5_all_countries', 15000, 9),
('germany5_all_countries', 16000, 10),
('germany5_all_countries', 17000, 11),
('germany5_all_countries', 18000, 12),
('germany5_all_countries', 19000, 13),
('germany5_all_countries', 20000, 14),
('germany5_all_countries', 21000, 15),
('germany5_all_countries', 22000, 16),
('germany5_all_countries', 23000, 17),
('germany5_all_countries', 24000, 18),
('germany5_all_countries', 25000, 19),
('germany5_neighbours', 11001, 2),
('germany5_neighbours', 11002, 1),
('germany5_neighbours', 11003, 2),
('germany5_neighbours', 11004, 2),
('germany5_neighbours', 11005, 1),
('germany5_neighbours', 11006, 3),
('germany5_neighbours', 11007, 3),
('germany5_neighbours', 11008, 3),
('germany5_neighbours', 11009, 4),
('germany5_neighbours', 11010, 4),
('germany5_neighbours', 11011, 4),
('germany5_neighbours', 11012, 4),
('germany5_neighbours', 11013, 1),
('germany5_neighbours', 11014, 1),
('germany5_neighbours', 11015, 1),
('germany5_neighbours', 11016, 3),
('germany5_neighbours', 11017, 5),
('germany5_neighbours', 11018, 5),
('germany5_neighbours', 11019, 2),
('germany5_neighbours', 11020, 1),
('germany5_neighbours', 11021, 1),
('germany5_neighbours', 12000, 6),
('germany5_neighbours', 17000, 7),
('germany5_neighbours', 18000, 8),
('germany5_neighbours', 19000, 9),
('germany5_neighbours', 20000, 10),
('germany5_neighbours', 21000, 11),
('germany5_neighbours', 22000, 12),
('germany5_neighbours', 23000, 13),
('germany5_neighbours', 24000, 14),
('germany5_neighbours', 25000, 15),
('germany5_norway', 11001, 2),
('germany5_norway', 11002, 1),
('germany5_norway', 11003, 2),
('germany5_norway', 11004, 2),
('germany5_norway', 11005, 1),
('germany5_norway', 11006, 3),
('germany5_norway', 11007, 3),
('germany5_norway', 11008, 3),
('germany5_norway', 11009, 4),
('germany5_norway', 11010, 4),
('germany5_norway', 11011, 4),
('germany5_norway', 11012, 4),
('germany5_norway', 11013, 1),
('germany5_norway', 11014, 1),
('germany5_norway', 11015, 1),
('germany5_norway', 11016, 3),
('germany5_norway', 11017, 5),
('germany5_norway', 11018, 5),
('germany5_norway', 11019, 2),
('germany5_norway', 11020, 1),
('germany5_norway', 11021, 1),
('germany5_norway', 19000, 6),
('germanyTSO_neighbours', 11001, 1),
('germanyTSO_neighbours', 11002, 1),
('germanyTSO_neighbours', 11003, 1),
('germanyTSO_neighbours', 11004, 1),
('germanyTSO_neighbours', 11005, 2),
('germanyTSO_neighbours', 11006, 2),
('germanyTSO_neighbours', 11007, 2),
('germanyTSO_neighbours', 11008, 2),
('germanyTSO_neighbours', 11009, 2),
('germanyTSO_neighbours', 11010, 2),
('germanyTSO_neighbours', 11011, 3),
('germanyTSO_neighbours', 11012, 3),
('germanyTSO_neighbours', 11013, 4),
('germanyTSO_neighbours', 11014, 4),
('germanyTSO_neighbours', 11015, 4),
('germanyTSO_neighbours', 11016, 4),
('germanyTSO_neighbours', 11017, 4),
('germanyTSO_neighbours', 11018, 4),
('germanyTSO_neighbours', 11019, 1),
('germanyTSO_neighbours', 11020, 4),
('germanyTSO_neighbours', 11021, 4),
('germanyTSO_neighbours', 12000, 5),
('germanyTSO_neighbours', 17000, 6),
('germanyTSO_neighbours', 18000, 7),
('germanyTSO_neighbours', 19000, 8),
('germanyTSO_neighbours', 20000, 9),
('germanyTSO_neighbours', 21000, 10),
('germanyTSO_neighbours', 22000, 11),
('germanyTSO_neighbours', 23000, 12),
('germanyTSO_neighbours', 24000, 13),
('germanyTSO_neighbours', 25000, 14),
('germany_neighbours_no_split', 11001, 1),
('germany_neighbours_no_split', 11002, 1),
('germany_neighbours_no_split', 11003, 1),
('germany_neighbours_no_split', 11004, 1),
('germany_neighbours_no_split', 11005, 1),
('germany_neighbours_no_split', 11006, 1),
('germany_neighbours_no_split', 11007, 1),
('germany_neighbours_no_split', 11008, 1),
('germany_neighbours_no_split', 11009, 1),
('germany_neighbours_no_split', 11010, 1),
('germany_neighbours_no_split', 11011, 1),
('germany_neighbours_no_split', 11012, 1),
('germany_neighbours_no_split', 11013, 1),
('germany_neighbours_no_split', 11014, 1),
('germany_neighbours_no_split', 11015, 1),
('germany_neighbours_no_split', 11016, 1),
('germany_neighbours_no_split', 11017, 1),
('germany_neighbours_no_split', 11018, 1),
('germany_neighbours_no_split', 11019, 1),
('germany_neighbours_no_split', 11020, 1),
('germany_neighbours_no_split', 11021, 1),
('germany_neighbours_no_split', 12000, 2),
('germany_neighbours_no_split', 17000, 3),
('germany_neighbours_no_split', 18000, 4),
('germany_neighbours_no_split', 19000, 5),
('germany_neighbours_no_split', 20000, 6),
('germany_neighbours_no_split', 21000, 7),
('germany_neighbours_no_split', 22000, 8),
('germany_neighbours_no_split', 23000, 9),
('germany_neighbours_no_split', 24000, 10),
('germany_neighbours_no_split', 25000, 11);

-- --------------------------------------------------------

--
-- Table structure for table `renewable_scenario`
--

CREATE TABLE IF NOT EXISTS `renewable_scenario` (
  `scenario_name` varchar(50) CHARACTER SET utf8 NOT NULL,
  `wind_onshore_scenario` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `wind_offshore_scenario` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `solar_scenario` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `runofriver_scenario` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `geothermal_scenario` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `biomass_scenario` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`scenario_name`),
  KEY `wind_onshore_scenario` (`wind_onshore_scenario`),
  KEY `wind_offshore_scenario` (`wind_offshore_scenario`),
  KEY `solar_scenario` (`solar_scenario`),
  KEY `runofriver_scenario` (`runofriver_scenario`),
  KEY `geothermal_scenario` (`geothermal_scenario`),
  KEY `biomass_scenario` (`biomass_scenario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `renewable_scenario`
--

INSERT INTO `renewable_scenario` (`scenario_name`, `wind_onshore_scenario`, `wind_offshore_scenario`, `solar_scenario`, `runofriver_scenario`, `geothermal_scenario`, `biomass_scenario`) VALUES
('NEP_2024_A', 'NEP_2024_A', 'NEP_2024_A', 'NEP_2024_A', 'NEP_2024_A', 'NEP_2024_A', 'NEP_2024_A'),
('NEP_2024_B', 'NEP_2024_B', 'NEP_2024_B', 'NEP_2024_B', 'NEP_2024_B', 'NEP_2024_B', 'NEP_2024_B'),
('NEP_2024_C', 'NEP_2024_C', 'NEP_2024_C', 'NEP_2024_C', 'NEP_2024_C', 'NEP_2024_C', 'NEP_2024_C'),
('NEP_2034_B', 'NEP_2034_B', 'NEP_2034_B', 'NEP_2034_B', 'NEP_2034_B', 'NEP_2034_B', 'NEP_2034_B'),
('status_quo_2012', 'status_quo_2012', 'status_quo_2012', 'status_quo_2012', 'status_quo_2012', 'status_quo_2012', 'status_quo_2012'),
('UBA_2050_Regionenverbund', 'UBA_2050_Regionenverbund', 'UBA_2050_Regionenverbund', 'UBA_2050_Regionenverbund', 'UBA_2050_Regionenverbund', 'UBA_2050_Regionenverbund', 'UBA_2050_Regionenverbund');

-- --------------------------------------------------------

--
-- Table structure for table `resources_scenario`
--

CREATE TABLE IF NOT EXISTS `resources_scenario` (
  `scenario_name` varchar(50) NOT NULL,
  `scenario_year` int(4) NOT NULL,
  `region_id` int(10) NOT NULL,
  `fuel` varchar(50) NOT NULL,
  `price` decimal(10,2) NOT NULL COMMENT '€/GJ and €/t for co2',
  `amount_per_year` int(10) NOT NULL,
  PRIMARY KEY (`scenario_name`,`scenario_year`,`region_id`,`fuel`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `resources_scenario`
--

INSERT INTO `resources_scenario` (`scenario_name`, `scenario_year`, `region_id`, `fuel`, `price`, `amount_per_year`) VALUES
('high', 2011, 0, 'biomass', 0.70, 0),
('high', 2011, 0, 'co2', 27.35, 0),
('high', 2011, 0, 'gas', 7.51, 0),
('high', 2011, 0, 'hard_coal', 3.66, 0),
('high', 2011, 0, 'lignite', 1.13, 0),
('high', 2011, 0, 'oil', 9.64, 0),
('high', 2011, 0, 'refuse', 0.00, 0),
('high', 2011, 0, 'uran', 0.62, 0),
('high', 2012, 0, 'biomass', 0.70, 0),
('high', 2012, 0, 'co2', 28.48, 0),
('high', 2012, 0, 'gas', 7.81, 0),
('high', 2012, 0, 'hard_coal', 3.82, 0),
('high', 2012, 0, 'lignite', 1.14, 0),
('high', 2012, 0, 'oil', 9.97, 0),
('high', 2012, 0, 'refuse', 0.00, 0),
('high', 2012, 0, 'uran', 0.62, 0),
('high', 2013, 0, 'biomass', 0.70, 0),
('high', 2013, 0, 'co2', 29.61, 0),
('high', 2013, 0, 'gas', 8.12, 0),
('high', 2013, 0, 'hard_coal', 3.99, 0),
('high', 2013, 0, 'lignite', 1.16, 0),
('high', 2013, 0, 'oil', 10.29, 0),
('high', 2013, 0, 'refuse', 0.00, 0),
('high', 2013, 0, 'uran', 0.62, 0),
('high', 2014, 0, 'biomass', 0.70, 0),
('high', 2014, 0, 'co2', 30.74, 0),
('high', 2014, 0, 'gas', 8.43, 0),
('high', 2014, 0, 'hard_coal', 4.15, 0),
('high', 2014, 0, 'lignite', 1.17, 0),
('high', 2014, 0, 'oil', 10.62, 0),
('high', 2014, 0, 'refuse', 0.00, 0),
('high', 2014, 0, 'uran', 0.62, 0),
('high', 2015, 0, 'biomass', 0.70, 0),
('high', 2015, 0, 'co2', 31.87, 0),
('high', 2015, 0, 'gas', 8.74, 0),
('high', 2015, 0, 'hard_coal', 4.31, 0),
('high', 2015, 0, 'lignite', 1.18, 0),
('high', 2015, 0, 'oil', 10.94, 0),
('high', 2015, 0, 'refuse', 0.00, 0),
('high', 2015, 0, 'uran', 0.62, 0),
('high', 2016, 0, 'biomass', 0.70, 0),
('high', 2016, 0, 'co2', 32.99, 0),
('high', 2016, 0, 'gas', 9.04, 0),
('high', 2016, 0, 'hard_coal', 4.47, 0),
('high', 2016, 0, 'lignite', 1.20, 0),
('high', 2016, 0, 'oil', 11.26, 0),
('high', 2016, 0, 'refuse', 0.00, 0),
('high', 2016, 0, 'uran', 0.62, 0),
('high', 2017, 0, 'biomass', 0.70, 0),
('high', 2017, 0, 'co2', 34.12, 0),
('high', 2017, 0, 'gas', 9.35, 0),
('high', 2017, 0, 'hard_coal', 4.63, 0),
('high', 2017, 0, 'lignite', 1.21, 0),
('high', 2017, 0, 'oil', 11.59, 0),
('high', 2017, 0, 'refuse', 0.00, 0),
('high', 2017, 0, 'uran', 0.62, 0),
('high', 2018, 0, 'biomass', 0.70, 0),
('high', 2018, 0, 'co2', 35.25, 0),
('high', 2018, 0, 'gas', 9.66, 0),
('high', 2018, 0, 'hard_coal', 4.79, 0),
('high', 2018, 0, 'lignite', 1.22, 0),
('high', 2018, 0, 'oil', 11.91, 0),
('high', 2018, 0, 'refuse', 0.00, 0),
('high', 2018, 0, 'uran', 0.62, 0),
('high', 2019, 0, 'biomass', 0.70, 0),
('high', 2019, 0, 'co2', 36.38, 0),
('high', 2019, 0, 'gas', 9.97, 0),
('high', 2019, 0, 'hard_coal', 4.95, 0),
('high', 2019, 0, 'lignite', 1.23, 0),
('high', 2019, 0, 'oil', 12.24, 0),
('high', 2019, 0, 'refuse', 0.00, 0),
('high', 2019, 0, 'uran', 0.62, 0),
('high', 2020, 0, 'biomass', 0.70, 0),
('high', 2020, 0, 'co2', 37.51, 0),
('high', 2020, 0, 'gas', 10.28, 0),
('high', 2020, 0, 'hard_coal', 5.11, 0),
('high', 2020, 0, 'lignite', 1.25, 0),
('high', 2020, 0, 'oil', 12.56, 0),
('high', 2020, 0, 'refuse', 0.00, 0),
('high', 2020, 0, 'uran', 0.62, 0),
('high', 2021, 0, 'biomass', 0.70, 0),
('high', 2021, 0, 'co2', 38.64, 0),
('high', 2021, 0, 'gas', 10.58, 0),
('high', 2021, 0, 'hard_coal', 5.27, 0),
('high', 2021, 0, 'lignite', 1.26, 0),
('high', 2021, 0, 'oil', 12.88, 0),
('high', 2021, 0, 'refuse', 0.00, 0),
('high', 2021, 0, 'uran', 0.62, 0),
('high', 2022, 0, 'biomass', 0.70, 0),
('high', 2022, 0, 'co2', 39.77, 0),
('high', 2022, 0, 'gas', 10.89, 0),
('high', 2022, 0, 'hard_coal', 5.43, 0),
('high', 2022, 0, 'lignite', 1.27, 0),
('high', 2022, 0, 'oil', 13.21, 0),
('high', 2022, 0, 'refuse', 0.00, 0),
('high', 2022, 0, 'uran', 0.62, 0),
('high', 2023, 0, 'biomass', 0.70, 0),
('high', 2023, 0, 'co2', 40.90, 0),
('high', 2023, 0, 'gas', 11.20, 0),
('high', 2023, 0, 'hard_coal', 5.59, 0),
('high', 2023, 0, 'lignite', 1.28, 0),
('high', 2023, 0, 'oil', 13.53, 0),
('high', 2023, 0, 'refuse', 0.00, 0),
('high', 2023, 0, 'uran', 0.62, 0),
('high', 2024, 0, 'biomass', 0.70, 0),
('high', 2024, 0, 'co2', 42.02, 0),
('high', 2024, 0, 'gas', 11.51, 0),
('high', 2024, 0, 'hard_coal', 5.75, 0),
('high', 2024, 0, 'lignite', 1.30, 0),
('high', 2024, 0, 'oil', 13.86, 0),
('high', 2024, 0, 'refuse', 0.00, 0),
('high', 2024, 0, 'uran', 0.62, 0),
('high', 2025, 0, 'biomass', 0.70, 0),
('high', 2025, 0, 'co2', 43.15, 0),
('high', 2025, 0, 'gas', 11.81, 0),
('high', 2025, 0, 'hard_coal', 5.91, 0),
('high', 2025, 0, 'lignite', 1.31, 0),
('high', 2025, 0, 'oil', 14.18, 0),
('high', 2025, 0, 'refuse', 0.00, 0),
('high', 2025, 0, 'uran', 0.62, 0),
('high', 2026, 0, 'biomass', 0.70, 0),
('high', 2026, 0, 'co2', 44.28, 0),
('high', 2026, 0, 'gas', 12.12, 0),
('high', 2026, 0, 'hard_coal', 6.07, 0),
('high', 2026, 0, 'lignite', 1.32, 0),
('high', 2026, 0, 'oil', 14.50, 0),
('high', 2026, 0, 'refuse', 0.00, 0),
('high', 2026, 0, 'uran', 0.62, 0),
('high', 2027, 0, 'biomass', 0.70, 0),
('high', 2027, 0, 'co2', 45.41, 0),
('high', 2027, 0, 'gas', 12.43, 0),
('high', 2027, 0, 'hard_coal', 6.23, 0),
('high', 2027, 0, 'lignite', 1.34, 0),
('high', 2027, 0, 'oil', 14.83, 0),
('high', 2027, 0, 'refuse', 0.00, 0),
('high', 2027, 0, 'uran', 0.62, 0),
('high', 2028, 0, 'biomass', 0.70, 0),
('high', 2028, 0, 'co2', 46.54, 0),
('high', 2028, 0, 'gas', 12.74, 0),
('high', 2028, 0, 'hard_coal', 6.40, 0),
('high', 2028, 0, 'lignite', 1.35, 0),
('high', 2028, 0, 'oil', 15.15, 0),
('high', 2028, 0, 'refuse', 0.00, 0),
('high', 2028, 0, 'uran', 0.62, 0),
('high', 2029, 0, 'biomass', 0.70, 0),
('high', 2029, 0, 'co2', 47.67, 0),
('high', 2029, 0, 'gas', 13.04, 0),
('high', 2029, 0, 'hard_coal', 6.56, 0),
('high', 2029, 0, 'lignite', 1.36, 0),
('high', 2029, 0, 'oil', 15.48, 0),
('high', 2029, 0, 'refuse', 0.00, 0),
('high', 2029, 0, 'uran', 0.62, 0),
('high', 2030, 0, 'biomass', 0.70, 0),
('high', 2030, 0, 'co2', 48.80, 0),
('high', 2030, 0, 'gas', 13.35, 0),
('high', 2030, 0, 'hard_coal', 6.72, 0),
('high', 2030, 0, 'lignite', 1.37, 0),
('high', 2030, 0, 'oil', 15.80, 0),
('high', 2030, 0, 'refuse', 0.00, 0),
('high', 2030, 0, 'uran', 0.62, 0),
('high', 2031, 0, 'biomass', 0.70, 0),
('high', 2031, 0, 'co2', 49.92, 0),
('high', 2031, 0, 'gas', 13.66, 0),
('high', 2031, 0, 'hard_coal', 6.88, 0),
('high', 2031, 0, 'lignite', 1.39, 0),
('high', 2031, 0, 'oil', 16.12, 0),
('high', 2031, 0, 'refuse', 0.00, 0),
('high', 2031, 0, 'uran', 0.62, 0),
('high', 2032, 0, 'biomass', 0.70, 0),
('high', 2032, 0, 'co2', 51.05, 0),
('high', 2032, 0, 'gas', 13.97, 0),
('high', 2032, 0, 'hard_coal', 7.04, 0),
('high', 2032, 0, 'lignite', 1.40, 0),
('high', 2032, 0, 'oil', 16.45, 0),
('high', 2032, 0, 'refuse', 0.00, 0),
('high', 2032, 0, 'uran', 0.62, 0),
('high', 2033, 0, 'biomass', 0.70, 0),
('high', 2033, 0, 'co2', 52.18, 0),
('high', 2033, 0, 'gas', 14.27, 0),
('high', 2033, 0, 'hard_coal', 7.20, 0),
('high', 2033, 0, 'lignite', 1.41, 0),
('high', 2033, 0, 'oil', 16.77, 0),
('high', 2033, 0, 'refuse', 0.00, 0),
('high', 2033, 0, 'uran', 0.62, 0),
('high', 2034, 0, 'biomass', 0.70, 0),
('high', 2034, 0, 'co2', 53.31, 0),
('high', 2034, 0, 'gas', 14.58, 0),
('high', 2034, 0, 'hard_coal', 7.36, 0),
('high', 2034, 0, 'lignite', 1.43, 0),
('high', 2034, 0, 'oil', 17.10, 0),
('high', 2034, 0, 'refuse', 0.00, 0),
('high', 2034, 0, 'uran', 0.62, 0),
('high', 2035, 0, 'biomass', 0.70, 0),
('high', 2035, 0, 'co2', 54.44, 0),
('high', 2035, 0, 'gas', 14.89, 0),
('high', 2035, 0, 'hard_coal', 7.52, 0),
('high', 2035, 0, 'lignite', 1.44, 0),
('high', 2035, 0, 'oil', 17.42, 0),
('high', 2035, 0, 'refuse', 0.00, 0),
('high', 2035, 0, 'uran', 0.62, 0),
('high', 2036, 0, 'biomass', 0.70, 0),
('high', 2036, 0, 'co2', 55.57, 0),
('high', 2036, 0, 'gas', 15.20, 0),
('high', 2036, 0, 'hard_coal', 7.68, 0),
('high', 2036, 0, 'lignite', 1.45, 0),
('high', 2036, 0, 'oil', 17.74, 0),
('high', 2036, 0, 'refuse', 0.00, 0),
('high', 2036, 0, 'uran', 0.62, 0),
('high', 2037, 0, 'biomass', 0.70, 0),
('high', 2037, 0, 'co2', 56.70, 0),
('high', 2037, 0, 'gas', 15.50, 0),
('high', 2037, 0, 'hard_coal', 7.84, 0),
('high', 2037, 0, 'lignite', 1.46, 0),
('high', 2037, 0, 'oil', 18.07, 0),
('high', 2037, 0, 'refuse', 0.00, 0),
('high', 2037, 0, 'uran', 0.62, 0),
('high', 2038, 0, 'biomass', 0.70, 0),
('high', 2038, 0, 'co2', 57.83, 0),
('high', 2038, 0, 'gas', 15.81, 0),
('high', 2038, 0, 'hard_coal', 8.00, 0),
('high', 2038, 0, 'lignite', 1.48, 0),
('high', 2038, 0, 'oil', 18.39, 0),
('high', 2038, 0, 'refuse', 0.00, 0),
('high', 2038, 0, 'uran', 0.62, 0),
('high', 2039, 0, 'biomass', 0.70, 0),
('high', 2039, 0, 'co2', 58.95, 0),
('high', 2039, 0, 'gas', 16.12, 0),
('high', 2039, 0, 'hard_coal', 8.16, 0),
('high', 2039, 0, 'lignite', 1.49, 0),
('high', 2039, 0, 'oil', 18.72, 0),
('high', 2039, 0, 'refuse', 0.00, 0),
('high', 2039, 0, 'uran', 0.62, 0),
('high', 2040, 0, 'biomass', 0.70, 0),
('high', 2040, 0, 'co2', 60.08, 0),
('high', 2040, 0, 'gas', 16.43, 0),
('high', 2040, 0, 'hard_coal', 8.32, 0),
('high', 2040, 0, 'lignite', 1.50, 0),
('high', 2040, 0, 'oil', 19.04, 0),
('high', 2040, 0, 'refuse', 0.00, 0),
('high', 2040, 0, 'uran', 0.62, 0),
('high', 2041, 0, 'biomass', 0.70, 0),
('high', 2041, 0, 'co2', 61.21, 0),
('high', 2041, 0, 'gas', 16.73, 0),
('high', 2041, 0, 'hard_coal', 8.48, 0),
('high', 2041, 0, 'lignite', 1.52, 0),
('high', 2041, 0, 'oil', 19.36, 0),
('high', 2041, 0, 'refuse', 0.00, 0),
('high', 2041, 0, 'uran', 0.62, 0),
('high', 2042, 0, 'biomass', 0.70, 0),
('high', 2042, 0, 'co2', 62.34, 0),
('high', 2042, 0, 'gas', 17.04, 0),
('high', 2042, 0, 'hard_coal', 8.65, 0),
('high', 2042, 0, 'lignite', 1.53, 0),
('high', 2042, 0, 'oil', 19.69, 0),
('high', 2042, 0, 'refuse', 0.00, 0),
('high', 2042, 0, 'uran', 0.62, 0),
('high', 2043, 0, 'biomass', 0.70, 0),
('high', 2043, 0, 'co2', 63.47, 0),
('high', 2043, 0, 'gas', 17.35, 0),
('high', 2043, 0, 'hard_coal', 8.81, 0),
('high', 2043, 0, 'lignite', 1.54, 0),
('high', 2043, 0, 'oil', 20.01, 0),
('high', 2043, 0, 'refuse', 0.00, 0),
('high', 2043, 0, 'uran', 0.62, 0),
('high', 2044, 0, 'biomass', 0.70, 0),
('high', 2044, 0, 'co2', 64.60, 0),
('high', 2044, 0, 'gas', 17.66, 0),
('high', 2044, 0, 'hard_coal', 8.97, 0),
('high', 2044, 0, 'lignite', 1.55, 0),
('high', 2044, 0, 'oil', 20.34, 0),
('high', 2044, 0, 'refuse', 0.00, 0),
('high', 2044, 0, 'uran', 0.62, 0),
('high', 2045, 0, 'biomass', 0.70, 0),
('high', 2045, 0, 'co2', 65.73, 0),
('high', 2045, 0, 'gas', 17.97, 0),
('high', 2045, 0, 'hard_coal', 9.13, 0),
('high', 2045, 0, 'lignite', 1.57, 0),
('high', 2045, 0, 'oil', 20.66, 0),
('high', 2045, 0, 'refuse', 0.00, 0),
('high', 2045, 0, 'uran', 0.62, 0),
('high', 2046, 0, 'biomass', 0.70, 0),
('high', 2046, 0, 'co2', 66.86, 0),
('high', 2046, 0, 'gas', 18.27, 0),
('high', 2046, 0, 'hard_coal', 9.29, 0),
('high', 2046, 0, 'lignite', 1.58, 0),
('high', 2046, 0, 'oil', 20.98, 0),
('high', 2046, 0, 'refuse', 0.00, 0),
('high', 2046, 0, 'uran', 0.62, 0),
('high', 2047, 0, 'biomass', 0.70, 0),
('high', 2047, 0, 'co2', 67.98, 0),
('high', 2047, 0, 'gas', 18.58, 0),
('high', 2047, 0, 'hard_coal', 9.45, 0),
('high', 2047, 0, 'lignite', 1.59, 0),
('high', 2047, 0, 'oil', 21.31, 0),
('high', 2047, 0, 'refuse', 0.00, 0),
('high', 2047, 0, 'uran', 0.62, 0),
('high', 2048, 0, 'biomass', 0.70, 0),
('high', 2048, 0, 'co2', 69.11, 0),
('high', 2048, 0, 'gas', 18.89, 0),
('high', 2048, 0, 'hard_coal', 9.61, 0),
('high', 2048, 0, 'lignite', 1.60, 0),
('high', 2048, 0, 'oil', 21.63, 0),
('high', 2048, 0, 'refuse', 0.00, 0),
('high', 2048, 0, 'uran', 0.62, 0),
('high', 2049, 0, 'biomass', 0.70, 0),
('high', 2049, 0, 'co2', 70.24, 0),
('high', 2049, 0, 'gas', 19.20, 0),
('high', 2049, 0, 'hard_coal', 9.77, 0),
('high', 2049, 0, 'lignite', 1.62, 0),
('high', 2049, 0, 'oil', 21.96, 0),
('high', 2049, 0, 'refuse', 0.00, 0),
('high', 2049, 0, 'uran', 0.62, 0),
('high', 2050, 0, 'biomass', 0.70, 0),
('high', 2050, 0, 'co2', 71.37, 0),
('high', 2050, 0, 'gas', 19.50, 0),
('high', 2050, 0, 'hard_coal', 9.93, 0),
('high', 2050, 0, 'lignite', 1.63, 0),
('high', 2050, 0, 'oil', 22.28, 0),
('high', 2050, 0, 'refuse', 0.00, 0),
('high', 2050, 0, 'uran', 0.62, 0),
('low', 2011, 0, 'biomass', 0.30, 0),
('low', 2011, 0, 'co2', 16.56, 0),
('low', 2011, 0, 'gas', 5.74, 0),
('low', 2011, 0, 'hard_coal', 2.93, 0),
('low', 2011, 0, 'lignite', 1.11, 0),
('low', 2011, 0, 'oil', 7.26, 0),
('low', 2011, 0, 'refuse', 0.00, 0),
('low', 2011, 0, 'uran', 0.62, 0),
('low', 2012, 0, 'biomass', 0.30, 0),
('low', 2012, 0, 'co2', 16.88, 0),
('low', 2012, 0, 'gas', 5.81, 0),
('low', 2012, 0, 'hard_coal', 2.96, 0),
('low', 2012, 0, 'lignite', 1.12, 0),
('low', 2012, 0, 'oil', 7.34, 0),
('low', 2012, 0, 'refuse', 0.00, 0),
('low', 2012, 0, 'uran', 0.62, 0),
('low', 2013, 0, 'biomass', 0.30, 0),
('low', 2013, 0, 'co2', 17.19, 0),
('low', 2013, 0, 'gas', 5.88, 0),
('low', 2013, 0, 'hard_coal', 2.99, 0),
('low', 2013, 0, 'lignite', 1.13, 0),
('low', 2013, 0, 'oil', 7.41, 0),
('low', 2013, 0, 'refuse', 0.00, 0),
('low', 2013, 0, 'uran', 0.62, 0),
('low', 2014, 0, 'biomass', 0.30, 0),
('low', 2014, 0, 'co2', 17.51, 0),
('low', 2014, 0, 'gas', 5.96, 0),
('low', 2014, 0, 'hard_coal', 3.03, 0),
('low', 2014, 0, 'lignite', 1.14, 0),
('low', 2014, 0, 'oil', 7.49, 0),
('low', 2014, 0, 'refuse', 0.00, 0),
('low', 2014, 0, 'uran', 0.62, 0),
('low', 2015, 0, 'biomass', 0.30, 0),
('low', 2015, 0, 'co2', 17.82, 0),
('low', 2015, 0, 'gas', 6.03, 0),
('low', 2015, 0, 'hard_coal', 3.06, 0),
('low', 2015, 0, 'lignite', 1.14, 0),
('low', 2015, 0, 'oil', 7.57, 0),
('low', 2015, 0, 'refuse', 0.00, 0),
('low', 2015, 0, 'uran', 0.62, 0),
('low', 2016, 0, 'biomass', 0.30, 0),
('low', 2016, 0, 'co2', 18.14, 0),
('low', 2016, 0, 'gas', 6.10, 0),
('low', 2016, 0, 'hard_coal', 3.09, 0),
('low', 2016, 0, 'lignite', 1.15, 0),
('low', 2016, 0, 'oil', 7.65, 0),
('low', 2016, 0, 'refuse', 0.00, 0),
('low', 2016, 0, 'uran', 0.62, 0),
('low', 2017, 0, 'biomass', 0.30, 0),
('low', 2017, 0, 'co2', 18.45, 0),
('low', 2017, 0, 'gas', 6.18, 0),
('low', 2017, 0, 'hard_coal', 3.12, 0),
('low', 2017, 0, 'lignite', 1.16, 0),
('low', 2017, 0, 'oil', 7.73, 0),
('low', 2017, 0, 'refuse', 0.00, 0),
('low', 2017, 0, 'uran', 0.62, 0),
('low', 2018, 0, 'biomass', 0.30, 0),
('low', 2018, 0, 'co2', 18.77, 0),
('low', 2018, 0, 'gas', 6.25, 0),
('low', 2018, 0, 'hard_coal', 3.16, 0),
('low', 2018, 0, 'lignite', 1.16, 0),
('low', 2018, 0, 'oil', 7.80, 0),
('low', 2018, 0, 'refuse', 0.00, 0),
('low', 2018, 0, 'uran', 0.62, 0),
('low', 2019, 0, 'biomass', 0.30, 0),
('low', 2019, 0, 'co2', 19.08, 0),
('low', 2019, 0, 'gas', 6.32, 0),
('low', 2019, 0, 'hard_coal', 3.19, 0),
('low', 2019, 0, 'lignite', 1.17, 0),
('low', 2019, 0, 'oil', 7.88, 0),
('low', 2019, 0, 'refuse', 0.00, 0),
('low', 2019, 0, 'uran', 0.62, 0),
('low', 2020, 0, 'biomass', 0.30, 0),
('low', 2020, 0, 'co2', 19.40, 0),
('low', 2020, 0, 'gas', 6.39, 0),
('low', 2020, 0, 'hard_coal', 3.22, 0),
('low', 2020, 0, 'lignite', 1.18, 0),
('low', 2020, 0, 'oil', 7.96, 0),
('low', 2020, 0, 'refuse', 0.00, 0),
('low', 2020, 0, 'uran', 0.62, 0),
('low', 2021, 0, 'biomass', 0.30, 0),
('low', 2021, 0, 'co2', 19.71, 0),
('low', 2021, 0, 'gas', 6.47, 0),
('low', 2021, 0, 'hard_coal', 3.26, 0),
('low', 2021, 0, 'lignite', 1.19, 0),
('low', 2021, 0, 'oil', 8.04, 0),
('low', 2021, 0, 'refuse', 0.00, 0),
('low', 2021, 0, 'uran', 0.62, 0),
('low', 2022, 0, 'biomass', 0.30, 0),
('low', 2022, 0, 'co2', 20.03, 0),
('low', 2022, 0, 'gas', 6.54, 0),
('low', 2022, 0, 'hard_coal', 3.29, 0),
('low', 2022, 0, 'lignite', 1.19, 0),
('low', 2022, 0, 'oil', 8.12, 0),
('low', 2022, 0, 'refuse', 0.00, 0),
('low', 2022, 0, 'uran', 0.62, 0),
('low', 2023, 0, 'biomass', 0.30, 0),
('low', 2023, 0, 'co2', 20.34, 0),
('low', 2023, 0, 'gas', 6.61, 0),
('low', 2023, 0, 'hard_coal', 3.32, 0),
('low', 2023, 0, 'lignite', 1.20, 0),
('low', 2023, 0, 'oil', 8.19, 0),
('low', 2023, 0, 'refuse', 0.00, 0),
('low', 2023, 0, 'uran', 0.62, 0),
('low', 2024, 0, 'biomass', 0.30, 0),
('low', 2024, 0, 'co2', 20.65, 0),
('low', 2024, 0, 'gas', 6.68, 0),
('low', 2024, 0, 'hard_coal', 3.35, 0),
('low', 2024, 0, 'lignite', 1.21, 0),
('low', 2024, 0, 'oil', 8.27, 0),
('low', 2024, 0, 'refuse', 0.00, 0),
('low', 2024, 0, 'uran', 0.62, 0),
('low', 2025, 0, 'biomass', 0.30, 0),
('low', 2025, 0, 'co2', 20.97, 0),
('low', 2025, 0, 'gas', 6.76, 0),
('low', 2025, 0, 'hard_coal', 3.39, 0),
('low', 2025, 0, 'lignite', 1.21, 0),
('low', 2025, 0, 'oil', 8.35, 0),
('low', 2025, 0, 'refuse', 0.00, 0),
('low', 2025, 0, 'uran', 0.62, 0),
('low', 2026, 0, 'biomass', 0.30, 0),
('low', 2026, 0, 'co2', 21.28, 0),
('low', 2026, 0, 'gas', 6.83, 0),
('low', 2026, 0, 'hard_coal', 3.42, 0),
('low', 2026, 0, 'lignite', 1.22, 0),
('low', 2026, 0, 'oil', 8.43, 0),
('low', 2026, 0, 'refuse', 0.00, 0),
('low', 2026, 0, 'uran', 0.62, 0),
('low', 2027, 0, 'biomass', 0.30, 0),
('low', 2027, 0, 'co2', 21.60, 0),
('low', 2027, 0, 'gas', 6.90, 0),
('low', 2027, 0, 'hard_coal', 3.45, 0),
('low', 2027, 0, 'lignite', 1.23, 0),
('low', 2027, 0, 'oil', 8.51, 0),
('low', 2027, 0, 'refuse', 0.00, 0),
('low', 2027, 0, 'uran', 0.62, 0),
('low', 2028, 0, 'biomass', 0.30, 0),
('low', 2028, 0, 'co2', 21.91, 0),
('low', 2028, 0, 'gas', 6.98, 0),
('low', 2028, 0, 'hard_coal', 3.49, 0),
('low', 2028, 0, 'lignite', 1.24, 0),
('low', 2028, 0, 'oil', 8.58, 0),
('low', 2028, 0, 'refuse', 0.00, 0),
('low', 2028, 0, 'uran', 0.62, 0),
('low', 2029, 0, 'biomass', 0.30, 0),
('low', 2029, 0, 'co2', 22.23, 0),
('low', 2029, 0, 'gas', 7.05, 0),
('low', 2029, 0, 'hard_coal', 3.52, 0),
('low', 2029, 0, 'lignite', 1.24, 0),
('low', 2029, 0, 'oil', 8.66, 0),
('low', 2029, 0, 'refuse', 0.00, 0),
('low', 2029, 0, 'uran', 0.62, 0),
('low', 2030, 0, 'biomass', 0.30, 0),
('low', 2030, 0, 'co2', 22.54, 0),
('low', 2030, 0, 'gas', 7.12, 0),
('low', 2030, 0, 'hard_coal', 3.55, 0),
('low', 2030, 0, 'lignite', 1.25, 0),
('low', 2030, 0, 'oil', 8.74, 0),
('low', 2030, 0, 'refuse', 0.00, 0),
('low', 2030, 0, 'uran', 0.62, 0),
('low', 2031, 0, 'biomass', 0.30, 0),
('low', 2031, 0, 'co2', 22.86, 0),
('low', 2031, 0, 'gas', 7.19, 0),
('low', 2031, 0, 'hard_coal', 3.58, 0),
('low', 2031, 0, 'lignite', 1.26, 0),
('low', 2031, 0, 'oil', 8.82, 0),
('low', 2031, 0, 'refuse', 0.00, 0),
('low', 2031, 0, 'uran', 0.62, 0),
('low', 2032, 0, 'biomass', 0.30, 0),
('low', 2032, 0, 'co2', 23.17, 0),
('low', 2032, 0, 'gas', 7.27, 0),
('low', 2032, 0, 'hard_coal', 3.62, 0),
('low', 2032, 0, 'lignite', 1.26, 0),
('low', 2032, 0, 'oil', 8.90, 0),
('low', 2032, 0, 'refuse', 0.00, 0),
('low', 2032, 0, 'uran', 0.62, 0),
('low', 2033, 0, 'biomass', 0.30, 0),
('low', 2033, 0, 'co2', 23.49, 0),
('low', 2033, 0, 'gas', 7.34, 0),
('low', 2033, 0, 'hard_coal', 3.65, 0),
('low', 2033, 0, 'lignite', 1.27, 0),
('low', 2033, 0, 'oil', 8.97, 0),
('low', 2033, 0, 'refuse', 0.00, 0),
('low', 2033, 0, 'uran', 0.62, 0),
('low', 2034, 0, 'biomass', 0.30, 0),
('low', 2034, 0, 'co2', 23.80, 0),
('low', 2034, 0, 'gas', 7.41, 0),
('low', 2034, 0, 'hard_coal', 3.68, 0),
('low', 2034, 0, 'lignite', 1.28, 0),
('low', 2034, 0, 'oil', 9.05, 0),
('low', 2034, 0, 'refuse', 0.00, 0),
('low', 2034, 0, 'uran', 0.62, 0),
('low', 2035, 0, 'biomass', 0.30, 0),
('low', 2035, 0, 'co2', 24.12, 0),
('low', 2035, 0, 'gas', 7.49, 0),
('low', 2035, 0, 'hard_coal', 3.71, 0),
('low', 2035, 0, 'lignite', 1.29, 0),
('low', 2035, 0, 'oil', 9.13, 0),
('low', 2035, 0, 'refuse', 0.00, 0),
('low', 2035, 0, 'uran', 0.62, 0),
('low', 2036, 0, 'biomass', 0.30, 0),
('low', 2036, 0, 'co2', 24.43, 0),
('low', 2036, 0, 'gas', 7.56, 0),
('low', 2036, 0, 'hard_coal', 3.75, 0),
('low', 2036, 0, 'lignite', 1.29, 0),
('low', 2036, 0, 'oil', 9.21, 0),
('low', 2036, 0, 'refuse', 0.00, 0),
('low', 2036, 0, 'uran', 0.62, 0),
('low', 2037, 0, 'biomass', 0.30, 0),
('low', 2037, 0, 'co2', 24.75, 0),
('low', 2037, 0, 'gas', 7.63, 0),
('low', 2037, 0, 'hard_coal', 3.78, 0),
('low', 2037, 0, 'lignite', 1.30, 0),
('low', 2037, 0, 'oil', 9.29, 0),
('low', 2037, 0, 'refuse', 0.00, 0),
('low', 2037, 0, 'uran', 0.62, 0),
('low', 2038, 0, 'biomass', 0.30, 0),
('low', 2038, 0, 'co2', 25.06, 0),
('low', 2038, 0, 'gas', 7.70, 0),
('low', 2038, 0, 'hard_coal', 3.81, 0),
('low', 2038, 0, 'lignite', 1.31, 0),
('low', 2038, 0, 'oil', 9.36, 0),
('low', 2038, 0, 'refuse', 0.00, 0),
('low', 2038, 0, 'uran', 0.62, 0),
('low', 2039, 0, 'biomass', 0.30, 0),
('low', 2039, 0, 'co2', 25.38, 0),
('low', 2039, 0, 'gas', 7.78, 0),
('low', 2039, 0, 'hard_coal', 3.85, 0),
('low', 2039, 0, 'lignite', 1.32, 0),
('low', 2039, 0, 'oil', 9.44, 0),
('low', 2039, 0, 'refuse', 0.00, 0),
('low', 2039, 0, 'uran', 0.62, 0),
('low', 2040, 0, 'biomass', 0.30, 0),
('low', 2040, 0, 'co2', 25.69, 0),
('low', 2040, 0, 'gas', 7.85, 0),
('low', 2040, 0, 'hard_coal', 3.88, 0),
('low', 2040, 0, 'lignite', 1.32, 0),
('low', 2040, 0, 'oil', 9.52, 0),
('low', 2040, 0, 'refuse', 0.00, 0),
('low', 2040, 0, 'uran', 0.62, 0),
('low', 2041, 0, 'biomass', 0.30, 0),
('low', 2041, 0, 'co2', 26.00, 0),
('low', 2041, 0, 'gas', 7.92, 0),
('low', 2041, 0, 'hard_coal', 3.91, 0),
('low', 2041, 0, 'lignite', 1.33, 0),
('low', 2041, 0, 'oil', 9.60, 0),
('low', 2041, 0, 'refuse', 0.00, 0),
('low', 2041, 0, 'uran', 0.62, 0),
('low', 2042, 0, 'biomass', 0.30, 0),
('low', 2042, 0, 'co2', 26.32, 0),
('low', 2042, 0, 'gas', 8.00, 0),
('low', 2042, 0, 'hard_coal', 3.94, 0),
('low', 2042, 0, 'lignite', 1.34, 0),
('low', 2042, 0, 'oil', 9.68, 0),
('low', 2042, 0, 'refuse', 0.00, 0),
('low', 2042, 0, 'uran', 0.62, 0),
('low', 2043, 0, 'biomass', 0.30, 0),
('low', 2043, 0, 'co2', 26.63, 0),
('low', 2043, 0, 'gas', 8.07, 0),
('low', 2043, 0, 'hard_coal', 3.98, 0),
('low', 2043, 0, 'lignite', 1.34, 0),
('low', 2043, 0, 'oil', 9.75, 0),
('low', 2043, 0, 'refuse', 0.00, 0),
('low', 2043, 0, 'uran', 0.62, 0),
('low', 2044, 0, 'biomass', 0.30, 0),
('low', 2044, 0, 'co2', 26.95, 0),
('low', 2044, 0, 'gas', 8.14, 0),
('low', 2044, 0, 'hard_coal', 4.01, 0),
('low', 2044, 0, 'lignite', 1.35, 0),
('low', 2044, 0, 'oil', 9.83, 0),
('low', 2044, 0, 'refuse', 0.00, 0),
('low', 2044, 0, 'uran', 0.62, 0),
('low', 2045, 0, 'biomass', 0.30, 0),
('low', 2045, 0, 'co2', 27.26, 0),
('low', 2045, 0, 'gas', 8.21, 0),
('low', 2045, 0, 'hard_coal', 4.04, 0),
('low', 2045, 0, 'lignite', 1.36, 0),
('low', 2045, 0, 'oil', 9.91, 0),
('low', 2045, 0, 'refuse', 0.00, 0),
('low', 2045, 0, 'uran', 0.62, 0),
('low', 2046, 0, 'biomass', 0.30, 0),
('low', 2046, 0, 'co2', 27.58, 0),
('low', 2046, 0, 'gas', 8.29, 0),
('low', 2046, 0, 'hard_coal', 4.08, 0),
('low', 2046, 0, 'lignite', 1.37, 0),
('low', 2046, 0, 'oil', 9.99, 0),
('low', 2046, 0, 'refuse', 0.00, 0),
('low', 2046, 0, 'uran', 0.62, 0),
('low', 2047, 0, 'biomass', 0.30, 0),
('low', 2047, 0, 'co2', 27.89, 0),
('low', 2047, 0, 'gas', 8.36, 0),
('low', 2047, 0, 'hard_coal', 4.11, 0),
('low', 2047, 0, 'lignite', 1.37, 0),
('low', 2047, 0, 'oil', 10.07, 0),
('low', 2047, 0, 'refuse', 0.00, 0),
('low', 2047, 0, 'uran', 0.62, 0),
('low', 2048, 0, 'biomass', 0.30, 0),
('low', 2048, 0, 'co2', 28.21, 0),
('low', 2048, 0, 'gas', 8.43, 0),
('low', 2048, 0, 'hard_coal', 4.14, 0),
('low', 2048, 0, 'lignite', 1.38, 0),
('low', 2048, 0, 'oil', 10.14, 0),
('low', 2048, 0, 'refuse', 0.00, 0),
('low', 2048, 0, 'uran', 0.62, 0),
('low', 2049, 0, 'biomass', 0.30, 0),
('low', 2049, 0, 'co2', 28.52, 0),
('low', 2049, 0, 'gas', 8.50, 0),
('low', 2049, 0, 'hard_coal', 4.17, 0),
('low', 2049, 0, 'lignite', 1.39, 0),
('low', 2049, 0, 'oil', 10.22, 0),
('low', 2049, 0, 'refuse', 0.00, 0),
('low', 2049, 0, 'uran', 0.62, 0),
('low', 2050, 0, 'biomass', 0.30, 0),
('low', 2050, 0, 'co2', 28.84, 0),
('low', 2050, 0, 'gas', 8.58, 0),
('low', 2050, 0, 'hard_coal', 4.21, 0),
('low', 2050, 0, 'lignite', 1.39, 0),
('low', 2050, 0, 'oil', 10.30, 0),
('low', 2050, 0, 'refuse', 0.00, 0),
('low', 2050, 0, 'uran', 0.62, 0),
('moderate', 2011, 0, 'biomass', 0.50, 0),
('moderate', 2011, 0, 'co2', 22.94, 0),
('moderate', 2011, 0, 'gas', 6.56, 0),
('moderate', 2011, 0, 'hard_coal', 3.37, 0),
('moderate', 2011, 0, 'lignite', 1.13, 0),
('moderate', 2011, 0, 'oil', 8.15, 0),
('moderate', 2011, 0, 'refuse', 0.00, 0),
('moderate', 2011, 0, 'uran', 0.62, 0),
('moderate', 2012, 0, 'biomass', 0.50, 0),
('moderate', 2012, 0, 'co2', 23.54, 0),
('moderate', 2012, 0, 'gas', 6.73, 0),
('moderate', 2012, 0, 'hard_coal', 3.45, 0),
('moderate', 2012, 0, 'lignite', 1.14, 0),
('moderate', 2012, 0, 'oil', 8.39, 0),
('moderate', 2012, 0, 'refuse', 0.00, 0),
('moderate', 2012, 0, 'uran', 0.62, 0),
('moderate', 2013, 0, 'biomass', 0.50, 0),
('moderate', 2013, 0, 'co2', 24.14, 0),
('moderate', 2013, 0, 'gas', 6.89, 0),
('moderate', 2013, 0, 'hard_coal', 3.52, 0),
('moderate', 2013, 0, 'lignite', 1.15, 0),
('moderate', 2013, 0, 'oil', 8.62, 0),
('moderate', 2013, 0, 'refuse', 0.00, 0),
('moderate', 2013, 0, 'uran', 0.62, 0),
('moderate', 2014, 0, 'biomass', 0.50, 0),
('moderate', 2014, 0, 'co2', 24.73, 0),
('moderate', 2014, 0, 'gas', 7.06, 0),
('moderate', 2014, 0, 'hard_coal', 3.60, 0),
('moderate', 2014, 0, 'lignite', 1.16, 0),
('moderate', 2014, 0, 'oil', 8.86, 0),
('moderate', 2014, 0, 'refuse', 0.00, 0),
('moderate', 2014, 0, 'uran', 0.62, 0),
('moderate', 2015, 0, 'biomass', 0.50, 0),
('moderate', 2015, 0, 'co2', 25.33, 0),
('moderate', 2015, 0, 'gas', 7.23, 0),
('moderate', 2015, 0, 'hard_coal', 3.67, 0),
('moderate', 2015, 0, 'lignite', 1.17, 0),
('moderate', 2015, 0, 'oil', 9.09, 0),
('moderate', 2015, 0, 'refuse', 0.00, 0),
('moderate', 2015, 0, 'uran', 0.62, 0),
('moderate', 2016, 0, 'biomass', 0.50, 0),
('moderate', 2016, 0, 'co2', 25.93, 0),
('moderate', 2016, 0, 'gas', 7.40, 0),
('moderate', 2016, 0, 'hard_coal', 3.75, 0),
('moderate', 2016, 0, 'lignite', 1.18, 0),
('moderate', 2016, 0, 'oil', 9.32, 0),
('moderate', 2016, 0, 'refuse', 0.00, 0),
('moderate', 2016, 0, 'uran', 0.62, 0),
('moderate', 2017, 0, 'biomass', 0.50, 0),
('moderate', 2017, 0, 'co2', 26.52, 0),
('moderate', 2017, 0, 'gas', 7.56, 0),
('moderate', 2017, 0, 'hard_coal', 3.83, 0),
('moderate', 2017, 0, 'lignite', 1.19, 0),
('moderate', 2017, 0, 'oil', 9.56, 0),
('moderate', 2017, 0, 'refuse', 0.00, 0),
('moderate', 2017, 0, 'uran', 0.62, 0),
('moderate', 2018, 0, 'biomass', 0.50, 0),
('moderate', 2018, 0, 'co2', 27.12, 0),
('moderate', 2018, 0, 'gas', 7.73, 0),
('moderate', 2018, 0, 'hard_coal', 3.90, 0),
('moderate', 2018, 0, 'lignite', 1.20, 0),
('moderate', 2018, 0, 'oil', 9.79, 0),
('moderate', 2018, 0, 'refuse', 0.00, 0),
('moderate', 2018, 0, 'uran', 0.62, 0),
('moderate', 2019, 0, 'biomass', 0.50, 0),
('moderate', 2019, 0, 'co2', 27.71, 0),
('moderate', 2019, 0, 'gas', 7.90, 0),
('moderate', 2019, 0, 'hard_coal', 3.98, 0),
('moderate', 2019, 0, 'lignite', 1.21, 0),
('moderate', 2019, 0, 'oil', 10.03, 0),
('moderate', 2019, 0, 'refuse', 0.00, 0),
('moderate', 2019, 0, 'uran', 0.62, 0),
('moderate', 2020, 0, 'biomass', 0.50, 0),
('moderate', 2020, 0, 'co2', 28.31, 0),
('moderate', 2020, 0, 'gas', 8.06, 0),
('moderate', 2020, 0, 'hard_coal', 4.05, 0),
('moderate', 2020, 0, 'lignite', 1.22, 0),
('moderate', 2020, 0, 'oil', 10.26, 0),
('moderate', 2020, 0, 'refuse', 0.00, 0),
('moderate', 2020, 0, 'uran', 0.62, 0),
('moderate', 2021, 0, 'biomass', 0.50, 0),
('moderate', 2021, 0, 'co2', 28.91, 0),
('moderate', 2021, 0, 'gas', 8.23, 0),
('moderate', 2021, 0, 'hard_coal', 4.13, 0),
('moderate', 2021, 0, 'lignite', 1.23, 0),
('moderate', 2021, 0, 'oil', 10.49, 0),
('moderate', 2021, 0, 'refuse', 0.00, 0),
('moderate', 2021, 0, 'uran', 0.62, 0),
('moderate', 2022, 0, 'biomass', 0.50, 0),
('moderate', 2022, 0, 'co2', 29.50, 0),
('moderate', 2022, 0, 'gas', 8.40, 0),
('moderate', 2022, 0, 'hard_coal', 4.21, 0),
('moderate', 2022, 0, 'lignite', 1.24, 0),
('moderate', 2022, 0, 'oil', 10.73, 0),
('moderate', 2022, 0, 'refuse', 0.00, 0),
('moderate', 2022, 0, 'uran', 0.62, 0),
('moderate', 2023, 0, 'biomass', 0.50, 0),
('moderate', 2023, 0, 'co2', 30.10, 0),
('moderate', 2023, 0, 'gas', 8.57, 0),
('moderate', 2023, 0, 'hard_coal', 4.28, 0),
('moderate', 2023, 0, 'lignite', 1.25, 0),
('moderate', 2023, 0, 'oil', 10.96, 0),
('moderate', 2023, 0, 'refuse', 0.00, 0),
('moderate', 2023, 0, 'uran', 0.62, 0),
('moderate', 2024, 0, 'biomass', 0.50, 0),
('moderate', 2024, 0, 'co2', 30.70, 0),
('moderate', 2024, 0, 'gas', 8.73, 0),
('moderate', 2024, 0, 'hard_coal', 4.36, 0),
('moderate', 2024, 0, 'lignite', 1.26, 0),
('moderate', 2024, 0, 'oil', 11.20, 0),
('moderate', 2024, 0, 'refuse', 0.00, 0),
('moderate', 2024, 0, 'uran', 0.62, 0),
('moderate', 2025, 0, 'biomass', 0.50, 0),
('moderate', 2025, 0, 'co2', 31.29, 0),
('moderate', 2025, 0, 'gas', 8.90, 0),
('moderate', 2025, 0, 'hard_coal', 4.43, 0),
('moderate', 2025, 0, 'lignite', 1.27, 0),
('moderate', 2025, 0, 'oil', 11.43, 0),
('moderate', 2025, 0, 'refuse', 0.00, 0),
('moderate', 2025, 0, 'uran', 0.62, 0),
('moderate', 2026, 0, 'biomass', 0.50, 0),
('moderate', 2026, 0, 'co2', 31.89, 0),
('moderate', 2026, 0, 'gas', 9.07, 0),
('moderate', 2026, 0, 'hard_coal', 4.51, 0),
('moderate', 2026, 0, 'lignite', 1.28, 0),
('moderate', 2026, 0, 'oil', 11.66, 0),
('moderate', 2026, 0, 'refuse', 0.00, 0),
('moderate', 2026, 0, 'uran', 0.62, 0),
('moderate', 2027, 0, 'biomass', 0.50, 0),
('moderate', 2027, 0, 'co2', 32.49, 0),
('moderate', 2027, 0, 'gas', 9.23, 0),
('moderate', 2027, 0, 'hard_coal', 4.59, 0),
('moderate', 2027, 0, 'lignite', 1.29, 0),
('moderate', 2027, 0, 'oil', 11.90, 0),
('moderate', 2027, 0, 'refuse', 0.00, 0),
('moderate', 2027, 0, 'uran', 0.62, 0),
('moderate', 2028, 0, 'biomass', 0.50, 0),
('moderate', 2028, 0, 'co2', 33.08, 0),
('moderate', 2028, 0, 'gas', 9.40, 0),
('moderate', 2028, 0, 'hard_coal', 4.66, 0),
('moderate', 2028, 0, 'lignite', 1.30, 0),
('moderate', 2028, 0, 'oil', 12.13, 0),
('moderate', 2028, 0, 'refuse', 0.00, 0),
('moderate', 2028, 0, 'uran', 0.62, 0),
('moderate', 2029, 0, 'biomass', 0.50, 0),
('moderate', 2029, 0, 'co2', 33.68, 0),
('moderate', 2029, 0, 'gas', 9.57, 0),
('moderate', 2029, 0, 'hard_coal', 4.74, 0),
('moderate', 2029, 0, 'lignite', 1.30, 0),
('moderate', 2029, 0, 'oil', 12.37, 0),
('moderate', 2029, 0, 'refuse', 0.00, 0),
('moderate', 2029, 0, 'uran', 0.62, 0),
('moderate', 2030, 0, 'biomass', 0.50, 0),
('moderate', 2030, 0, 'co2', 34.28, 0),
('moderate', 2030, 0, 'gas', 9.74, 0),
('moderate', 2030, 0, 'hard_coal', 4.82, 0),
('moderate', 2030, 0, 'lignite', 1.31, 0),
('moderate', 2030, 0, 'oil', 12.60, 0),
('moderate', 2030, 0, 'refuse', 0.00, 0),
('moderate', 2030, 0, 'uran', 0.62, 0),
('moderate', 2031, 0, 'biomass', 0.50, 0),
('moderate', 2031, 0, 'co2', 34.87, 0),
('moderate', 2031, 0, 'gas', 9.90, 0),
('moderate', 2031, 0, 'hard_coal', 4.89, 0),
('moderate', 2031, 0, 'lignite', 1.32, 0),
('moderate', 2031, 0, 'oil', 12.83, 0),
('moderate', 2031, 0, 'refuse', 0.00, 0),
('moderate', 2031, 0, 'uran', 0.62, 0),
('moderate', 2032, 0, 'biomass', 0.50, 0),
('moderate', 2032, 0, 'co2', 35.47, 0),
('moderate', 2032, 0, 'gas', 10.07, 0),
('moderate', 2032, 0, 'hard_coal', 4.97, 0),
('moderate', 2032, 0, 'lignite', 1.33, 0),
('moderate', 2032, 0, 'oil', 13.07, 0),
('moderate', 2032, 0, 'refuse', 0.00, 0),
('moderate', 2032, 0, 'uran', 0.62, 0),
('moderate', 2033, 0, 'biomass', 0.50, 0),
('moderate', 2033, 0, 'co2', 36.06, 0),
('moderate', 2033, 0, 'gas', 10.24, 0),
('moderate', 2033, 0, 'hard_coal', 5.04, 0),
('moderate', 2033, 0, 'lignite', 1.34, 0),
('moderate', 2033, 0, 'oil', 13.30, 0),
('moderate', 2033, 0, 'refuse', 0.00, 0),
('moderate', 2033, 0, 'uran', 0.62, 0),
('moderate', 2034, 0, 'biomass', 0.50, 0),
('moderate', 2034, 0, 'co2', 36.66, 0),
('moderate', 2034, 0, 'gas', 10.40, 0),
('moderate', 2034, 0, 'hard_coal', 5.12, 0),
('moderate', 2034, 0, 'lignite', 1.35, 0),
('moderate', 2034, 0, 'oil', 13.54, 0),
('moderate', 2034, 0, 'refuse', 0.00, 0),
('moderate', 2034, 0, 'uran', 0.62, 0),
('moderate', 2035, 0, 'biomass', 0.50, 0),
('moderate', 2035, 0, 'co2', 37.26, 0),
('moderate', 2035, 0, 'gas', 10.57, 0),
('moderate', 2035, 0, 'hard_coal', 5.20, 0),
('moderate', 2035, 0, 'lignite', 1.36, 0),
('moderate', 2035, 0, 'oil', 13.77, 0),
('moderate', 2035, 0, 'refuse', 0.00, 0),
('moderate', 2035, 0, 'uran', 0.62, 0),
('moderate', 2036, 0, 'biomass', 0.50, 0),
('moderate', 2036, 0, 'co2', 37.85, 0),
('moderate', 2036, 0, 'gas', 10.74, 0),
('moderate', 2036, 0, 'hard_coal', 5.27, 0),
('moderate', 2036, 0, 'lignite', 1.37, 0),
('moderate', 2036, 0, 'oil', 14.00, 0),
('moderate', 2036, 0, 'refuse', 0.00, 0),
('moderate', 2036, 0, 'uran', 0.62, 0),
('moderate', 2037, 0, 'biomass', 0.50, 0),
('moderate', 2037, 0, 'co2', 38.45, 0),
('moderate', 2037, 0, 'gas', 10.91, 0),
('moderate', 2037, 0, 'hard_coal', 5.35, 0),
('moderate', 2037, 0, 'lignite', 1.38, 0),
('moderate', 2037, 0, 'oil', 14.24, 0),
('moderate', 2037, 0, 'refuse', 0.00, 0),
('moderate', 2037, 0, 'uran', 0.62, 0),
('moderate', 2038, 0, 'biomass', 0.50, 0),
('moderate', 2038, 0, 'co2', 39.05, 0),
('moderate', 2038, 0, 'gas', 11.07, 0),
('moderate', 2038, 0, 'hard_coal', 5.42, 0),
('moderate', 2038, 0, 'lignite', 1.39, 0),
('moderate', 2038, 0, 'oil', 14.47, 0),
('moderate', 2038, 0, 'refuse', 0.00, 0),
('moderate', 2038, 0, 'uran', 0.62, 0),
('moderate', 2039, 0, 'biomass', 0.50, 0),
('moderate', 2039, 0, 'co2', 39.64, 0),
('moderate', 2039, 0, 'gas', 11.24, 0),
('moderate', 2039, 0, 'hard_coal', 5.50, 0),
('moderate', 2039, 0, 'lignite', 1.40, 0),
('moderate', 2039, 0, 'oil', 14.71, 0),
('moderate', 2039, 0, 'refuse', 0.00, 0),
('moderate', 2039, 0, 'uran', 0.62, 0),
('moderate', 2040, 0, 'biomass', 0.50, 0),
('moderate', 2040, 0, 'co2', 40.24, 0),
('moderate', 2040, 0, 'gas', 11.41, 0),
('moderate', 2040, 0, 'hard_coal', 5.58, 0),
('moderate', 2040, 0, 'lignite', 1.41, 0),
('moderate', 2040, 0, 'oil', 14.94, 0),
('moderate', 2040, 0, 'refuse', 0.00, 0),
('moderate', 2040, 0, 'uran', 0.62, 0),
('moderate', 2041, 0, 'biomass', 0.50, 0),
('moderate', 2041, 0, 'co2', 40.84, 0),
('moderate', 2041, 0, 'gas', 11.58, 0),
('moderate', 2041, 0, 'hard_coal', 5.65, 0),
('moderate', 2041, 0, 'lignite', 1.42, 0),
('moderate', 2041, 0, 'oil', 15.17, 0),
('moderate', 2041, 0, 'refuse', 0.00, 0),
('moderate', 2041, 0, 'uran', 0.62, 0),
('moderate', 2042, 0, 'biomass', 0.50, 0),
('moderate', 2042, 0, 'co2', 41.43, 0),
('moderate', 2042, 0, 'gas', 11.74, 0),
('moderate', 2042, 0, 'hard_coal', 5.73, 0),
('moderate', 2042, 0, 'lignite', 1.43, 0),
('moderate', 2042, 0, 'oil', 15.41, 0),
('moderate', 2042, 0, 'refuse', 0.00, 0),
('moderate', 2042, 0, 'uran', 0.62, 0),
('moderate', 2043, 0, 'biomass', 0.50, 0),
('moderate', 2043, 0, 'co2', 42.03, 0),
('moderate', 2043, 0, 'gas', 11.91, 0),
('moderate', 2043, 0, 'hard_coal', 5.80, 0),
('moderate', 2043, 0, 'lignite', 1.44, 0),
('moderate', 2043, 0, 'oil', 15.64, 0),
('moderate', 2043, 0, 'refuse', 0.00, 0),
('moderate', 2043, 0, 'uran', 0.62, 0),
('moderate', 2044, 0, 'biomass', 0.50, 0),
('moderate', 2044, 0, 'co2', 42.62, 0),
('moderate', 2044, 0, 'gas', 12.08, 0),
('moderate', 2044, 0, 'hard_coal', 5.88, 0),
('moderate', 2044, 0, 'lignite', 1.45, 0),
('moderate', 2044, 0, 'oil', 15.88, 0),
('moderate', 2044, 0, 'refuse', 0.00, 0),
('moderate', 2044, 0, 'uran', 0.62, 0),
('moderate', 2045, 0, 'biomass', 0.50, 0),
('moderate', 2045, 0, 'co2', 43.22, 0),
('moderate', 2045, 0, 'gas', 12.24, 0),
('moderate', 2045, 0, 'hard_coal', 5.96, 0),
('moderate', 2045, 0, 'lignite', 1.46, 0),
('moderate', 2045, 0, 'oil', 16.11, 0),
('moderate', 2045, 0, 'refuse', 0.00, 0),
('moderate', 2045, 0, 'uran', 0.62, 0),
('moderate', 2046, 0, 'biomass', 0.50, 0),
('moderate', 2046, 0, 'co2', 43.82, 0),
('moderate', 2046, 0, 'gas', 12.41, 0),
('moderate', 2046, 0, 'hard_coal', 6.03, 0),
('moderate', 2046, 0, 'lignite', 1.47, 0),
('moderate', 2046, 0, 'oil', 16.34, 0),
('moderate', 2046, 0, 'refuse', 0.00, 0),
('moderate', 2046, 0, 'uran', 0.62, 0),
('moderate', 2047, 0, 'biomass', 0.50, 0),
('moderate', 2047, 0, 'co2', 44.41, 0),
('moderate', 2047, 0, 'gas', 12.58, 0),
('moderate', 2047, 0, 'hard_coal', 6.11, 0),
('moderate', 2047, 0, 'lignite', 1.48, 0),
('moderate', 2047, 0, 'oil', 16.58, 0),
('moderate', 2047, 0, 'refuse', 0.00, 0),
('moderate', 2047, 0, 'uran', 0.62, 0),
('moderate', 2048, 0, 'biomass', 0.50, 0),
('moderate', 2048, 0, 'co2', 45.01, 0),
('moderate', 2048, 0, 'gas', 12.75, 0),
('moderate', 2048, 0, 'hard_coal', 6.18, 0),
('moderate', 2048, 0, 'lignite', 1.49, 0),
('moderate', 2048, 0, 'oil', 16.81, 0),
('moderate', 2048, 0, 'refuse', 0.00, 0),
('moderate', 2048, 0, 'uran', 0.62, 0),
('moderate', 2049, 0, 'biomass', 0.50, 0),
('moderate', 2049, 0, 'co2', 45.61, 0),
('moderate', 2049, 0, 'gas', 12.91, 0),
('moderate', 2049, 0, 'hard_coal', 6.26, 0),
('moderate', 2049, 0, 'lignite', 1.50, 0),
('moderate', 2049, 0, 'oil', 17.05, 0),
('moderate', 2049, 0, 'refuse', 0.00, 0),
('moderate', 2049, 0, 'uran', 0.62, 0),
('moderate', 2050, 0, 'biomass', 0.50, 0),
('moderate', 2050, 0, 'co2', 46.20, 0),
('moderate', 2050, 0, 'gas', 13.08, 0),
('moderate', 2050, 0, 'hard_coal', 6.34, 0),
('moderate', 2050, 0, 'lignite', 1.51, 0),
('moderate', 2050, 0, 'oil', 17.28, 0),
('moderate', 2050, 0, 'refuse', 0.00, 0),
('moderate', 2050, 0, 'uran', 0.62, 0);

-- --------------------------------------------------------

--
-- Table structure for table `runofriver_scenario`
--

CREATE TABLE IF NOT EXISTS `runofriver_scenario` (
  `scenario_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `region_id` int(8) NOT NULL DEFAULT '0',
  `installed_capacity` decimal(10,2) DEFAULT NULL COMMENT '[MW] including the already installed capacities',
  PRIMARY KEY (`scenario_name`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `runofriver_scenario`
--

INSERT INTO `runofriver_scenario` (`scenario_name`, `region_id`, `installed_capacity`) VALUES
('NEP_2024_A', 11001, 5.00),
('NEP_2024_A', 11002, 0.00),
('NEP_2024_A', 11003, 79.00),
('NEP_2024_A', 11004, 100.00),
('NEP_2024_A', 11005, 2.00),
('NEP_2024_A', 11006, 70.00),
('NEP_2024_A', 11007, 138.00),
('NEP_2024_A', 11008, 77.00),
('NEP_2024_A', 11009, 224.00),
('NEP_2024_A', 11010, 526.00),
('NEP_2024_A', 11011, 139.00),
('NEP_2024_A', 11012, 895.00),
('NEP_2024_A', 11013, 8.00),
('NEP_2024_A', 11014, 19.00),
('NEP_2024_A', 11015, 64.00),
('NEP_2024_A', 11016, 76.00),
('NEP_2024_A', 11017, 311.00),
('NEP_2024_A', 11018, 1667.00),
('NEP_2024_B', 11001, 5.00),
('NEP_2024_B', 11002, 0.00),
('NEP_2024_B', 11003, 85.00),
('NEP_2024_B', 11004, 106.00),
('NEP_2024_B', 11005, 2.00),
('NEP_2024_B', 11006, 75.00),
('NEP_2024_B', 11007, 147.00),
('NEP_2024_B', 11008, 82.00),
('NEP_2024_B', 11009, 240.00),
('NEP_2024_B', 11010, 562.00),
('NEP_2024_B', 11011, 149.00),
('NEP_2024_B', 11012, 956.00),
('NEP_2024_B', 11013, 9.00),
('NEP_2024_B', 11014, 20.00),
('NEP_2024_B', 11015, 68.00),
('NEP_2024_B', 11016, 81.00),
('NEP_2024_B', 11017, 332.00),
('NEP_2024_B', 11018, 1781.00),
('NEP_2024_C', 11001, 4.00),
('NEP_2024_C', 11002, 0.00),
('NEP_2024_C', 11003, 72.00),
('NEP_2024_C', 11004, 91.00),
('NEP_2024_C', 11005, 2.00),
('NEP_2024_C', 11006, 64.00),
('NEP_2024_C', 11007, 126.00),
('NEP_2024_C', 11008, 70.00),
('NEP_2024_C', 11009, 204.00),
('NEP_2024_C', 11010, 478.00),
('NEP_2024_C', 11011, 127.00),
('NEP_2024_C', 11012, 813.00),
('NEP_2024_C', 11013, 7.00),
('NEP_2024_C', 11014, 17.00),
('NEP_2024_C', 11015, 58.00),
('NEP_2024_C', 11016, 69.00),
('NEP_2024_C', 11017, 282.00),
('NEP_2024_C', 11018, 1516.00),
('NEP_2034_B', 11001, 6.00),
('NEP_2034_B', 11002, 0.00),
('NEP_2034_B', 11003, 90.00),
('NEP_2034_B', 11004, 113.00),
('NEP_2034_B', 11005, 2.00),
('NEP_2034_B', 11006, 80.00),
('NEP_2034_B', 11007, 157.00),
('NEP_2034_B', 11008, 87.00),
('NEP_2034_B', 11009, 255.00),
('NEP_2034_B', 11010, 598.00),
('NEP_2034_B', 11011, 158.00),
('NEP_2034_B', 11012, 1017.00),
('NEP_2034_B', 11013, 9.00),
('NEP_2034_B', 11014, 22.00),
('NEP_2034_B', 11015, 73.00),
('NEP_2034_B', 11016, 86.00),
('NEP_2034_B', 11017, 353.00),
('NEP_2034_B', 11018, 1894.00),
('status_quo_2012', 11001, 5.00),
('status_quo_2012', 11002, 0.30),
('status_quo_2012', 11003, 80.90),
('status_quo_2012', 11004, 101.70),
('status_quo_2012', 11005, 1.80),
('status_quo_2012', 11006, 71.90),
('status_quo_2012', 11007, 141.00),
('status_quo_2012', 11008, 78.50),
('status_quo_2012', 11009, 229.00),
('status_quo_2012', 11010, 537.40),
('status_quo_2012', 11011, 142.20),
('status_quo_2012', 11012, 913.70),
('status_quo_2012', 11013, 8.30),
('status_quo_2012', 11014, 19.60),
('status_quo_2012', 11015, 65.30),
('status_quo_2012', 11016, 77.30),
('status_quo_2012', 11017, 317.20),
('status_quo_2012', 11018, 1702.70),
('status_quo_2012', 12000, 658.00),
('status_quo_2012', 13000, 109.00),
('status_quo_2012', 14000, 72.00),
('status_quo_2012', 16000, 2597.00),
('status_quo_2012', 18000, 8.00),
('status_quo_2012', 19000, 4773.14),
('status_quo_2012', 20000, 38.00),
('status_quo_2012', 21000, 290.00),
('status_quo_2012', 22000, 6292.00),
('status_quo_2012', 23000, 4228.00),
('status_quo_2012', 24000, 3365.00),
('status_quo_2012', 25000, 632.00),
('UBA_2050_Regionenverbund', 11001, 6.00),
('UBA_2050_Regionenverbund', 11002, 0.00),
('UBA_2050_Regionenverbund', 11003, 94.00),
('UBA_2050_Regionenverbund', 11004, 118.00),
('UBA_2050_Regionenverbund', 11005, 2.00),
('UBA_2050_Regionenverbund', 11006, 83.00),
('UBA_2050_Regionenverbund', 11007, 163.00),
('UBA_2050_Regionenverbund', 11008, 91.00),
('UBA_2050_Regionenverbund', 11009, 265.00),
('UBA_2050_Regionenverbund', 11010, 622.00),
('UBA_2050_Regionenverbund', 11011, 165.00),
('UBA_2050_Regionenverbund', 11012, 1057.00),
('UBA_2050_Regionenverbund', 11013, 10.00),
('UBA_2050_Regionenverbund', 11014, 23.00),
('UBA_2050_Regionenverbund', 11015, 76.00),
('UBA_2050_Regionenverbund', 11016, 89.00),
('UBA_2050_Regionenverbund', 11017, 367.00),
('UBA_2050_Regionenverbund', 11018, 1970.00);

-- --------------------------------------------------------

--
-- Table structure for table `solar_scenario`
--

CREATE TABLE IF NOT EXISTS `solar_scenario` (
  `scenario_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `region_id` int(8) NOT NULL DEFAULT '0',
  `installed_capacity` decimal(10,2) DEFAULT NULL COMMENT '[MW] including the already installed capacities',
  PRIMARY KEY (`scenario_name`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `solar_scenario`
--

INSERT INTO `solar_scenario` (`scenario_name`, `region_id`, `installed_capacity`) VALUES
('NEP_2024_A', 11001, 6282.00),
('NEP_2024_A', 11002, 0.00),
('NEP_2024_A', 11003, 2541.00),
('NEP_2024_A', 11004, 2877.00),
('NEP_2024_A', 11005, 1055.00),
('NEP_2024_A', 11006, 2021.00),
('NEP_2024_A', 11007, 2107.00),
('NEP_2024_A', 11008, 1919.00),
('NEP_2024_A', 11009, 3142.00),
('NEP_2024_A', 11010, 2695.00),
('NEP_2024_A', 11011, 1771.00),
('NEP_2024_A', 11012, 5829.00),
('NEP_2024_A', 11013, 2300.00),
('NEP_2024_A', 11014, 2453.00),
('NEP_2024_A', 11015, 2738.00),
('NEP_2024_A', 11016, 2666.00),
('NEP_2024_A', 11017, 7734.00),
('NEP_2024_A', 11018, 6671.00),
('NEP_2024_B', 11001, 6412.00),
('NEP_2024_B', 11002, 0.00),
('NEP_2024_B', 11003, 2690.00),
('NEP_2024_B', 11004, 2998.00),
('NEP_2024_B', 11005, 1079.00),
('NEP_2024_B', 11006, 2083.00),
('NEP_2024_B', 11007, 2171.00),
('NEP_2024_B', 11008, 1982.00),
('NEP_2024_B', 11009, 3234.00),
('NEP_2024_B', 11010, 2773.00),
('NEP_2024_B', 11011, 1818.00),
('NEP_2024_B', 11012, 5982.00),
('NEP_2024_B', 11013, 2300.00),
('NEP_2024_B', 11014, 2496.00),
('NEP_2024_B', 11015, 2795.00),
('NEP_2024_B', 11016, 2759.00),
('NEP_2024_B', 11017, 7961.00),
('NEP_2024_B', 11018, 6866.00),
('NEP_2024_C', 11001, 5358.00),
('NEP_2024_C', 11002, 100.00),
('NEP_2024_C', 11003, 3118.00),
('NEP_2024_C', 11004, 2824.00),
('NEP_2024_C', 11005, 1225.00),
('NEP_2024_C', 11006, 1710.00),
('NEP_2024_C', 11007, 1782.00),
('NEP_2024_C', 11008, 1911.00),
('NEP_2024_C', 11009, 3828.00),
('NEP_2024_C', 11010, 2253.00),
('NEP_2024_C', 11011, 2331.00),
('NEP_2024_C', 11012, 7669.00),
('NEP_2024_C', 11013, 2000.00),
('NEP_2024_C', 11014, 3093.00),
('NEP_2024_C', 11015, 3352.00),
('NEP_2024_C', 11016, 3398.00),
('NEP_2024_C', 11017, 6468.00),
('NEP_2024_C', 11018, 5579.00),
('NEP_2034_B', 11001, 6726.00),
('NEP_2034_B', 11002, 0.00),
('NEP_2034_B', 11003, 2742.00),
('NEP_2034_B', 11004, 3132.00),
('NEP_2034_B', 11005, 1140.00),
('NEP_2034_B', 11006, 2208.00),
('NEP_2034_B', 11007, 2301.00),
('NEP_2034_B', 11008, 2106.00),
('NEP_2034_B', 11009, 3397.00),
('NEP_2034_B', 11010, 2915.00),
('NEP_2034_B', 11011, 1911.00),
('NEP_2034_B', 11012, 6289.00),
('NEP_2034_B', 11013, 2500.00),
('NEP_2034_B', 11014, 2627.00),
('NEP_2034_B', 11015, 2950.00),
('NEP_2034_B', 11016, 2872.00),
('NEP_2034_B', 11017, 8368.00),
('NEP_2034_B', 11018, 7217.00),
('status_quo_2012', 11001, 2334.08),
('status_quo_2012', 11002, 31.30),
('status_quo_2012', 11003, 1376.02),
('status_quo_2012', 11004, 1049.95),
('status_quo_2012', 11005, 1088.47),
('status_quo_2012', 11006, 1442.50),
('status_quo_2012', 11007, 915.60),
('status_quo_2012', 11008, 787.03),
('status_quo_2012', 11009, 1846.85),
('status_quo_2012', 11010, 1982.53),
('status_quo_2012', 11011, 1063.94),
('status_quo_2012', 11012, 3133.88),
('status_quo_2012', 11013, 1247.78),
('status_quo_2012', 11014, 1445.94),
('status_quo_2012', 11015, 1039.60),
('status_quo_2012', 11016, 1556.04),
('status_quo_2012', 11017, 3598.52),
('status_quo_2012', 11018, 4208.49),
('status_quo_2012', 12000, 1.00),
('status_quo_2012', 13000, 8.00),
('status_quo_2012', 15000, 38.00),
('status_quo_2012', 17000, 25.00),
('status_quo_2012', 18000, 407.00),
('status_quo_2012', 20000, 71.00),
('status_quo_2012', 21000, 2548.00),
('status_quo_2012', 22000, 3492.00),
('status_quo_2012', 23000, 192.00),
('status_quo_2012', 24000, 172.00),
('status_quo_2012', 25000, 2086.00),
('UBA_2050_Regionenverbund', 11001, 19567.00),
('UBA_2050_Regionenverbund', 11002, 259.00),
('UBA_2050_Regionenverbund', 11003, 8699.00),
('UBA_2050_Regionenverbund', 11004, 8226.00),
('UBA_2050_Regionenverbund', 11005, 2706.00),
('UBA_2050_Regionenverbund', 11006, 3583.00),
('UBA_2050_Regionenverbund', 11007, 3734.00),
('UBA_2050_Regionenverbund', 11008, 4010.00),
('UBA_2050_Regionenverbund', 11009, 7172.00),
('UBA_2050_Regionenverbund', 11010, 3658.00),
('UBA_2050_Regionenverbund', 11011, 2853.00),
('UBA_2050_Regionenverbund', 11012, 9387.00),
('UBA_2050_Regionenverbund', 11013, 5387.00),
('UBA_2050_Regionenverbund', 11014, 7080.00),
('UBA_2050_Regionenverbund', 11015, 7454.00),
('UBA_2050_Regionenverbund', 11016, 6670.00),
('UBA_2050_Regionenverbund', 11017, 10500.00),
('UBA_2050_Regionenverbund', 11018, 9056.00);

-- --------------------------------------------------------

--
-- Table structure for table `storage_scenario`
--

CREATE TABLE IF NOT EXISTS `storage_scenario` (
  `scenario_name` varchar(50) CHARACTER SET utf8 NOT NULL,
  `hydro_storage_scenario` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `other_storage_scenario` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`scenario_name`),
  KEY `hydro_storage_scenario` (`hydro_storage_scenario`),
  KEY `other_storage_scenario` (`other_storage_scenario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `storage_scenario`
--

INSERT INTO `storage_scenario` (`scenario_name`, `hydro_storage_scenario`, `other_storage_scenario`) VALUES
('NEP_2023_hydro', 'NEP_2023_ABC', 'status_quo_2012'),
('plus_hydro_Norway10GW', 'plus_hydro_Norway10GW', 'status_quo_2012'),
('status_quo_2012', 'status_quo_2012', 'status_quo_2012');

-- --------------------------------------------------------

--
-- Table structure for table `thermal_pp_scenario`
--

CREATE TABLE IF NOT EXISTS `thermal_pp_scenario` (
  `scenario_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'standard',
  `region_id` int(5) NOT NULL,
  `fuel` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `installed_capacity` decimal(10,3) DEFAULT NULL COMMENT 'MW',
  `lifetime` int(3) DEFAULT NULL,
  `limitation` enum('installed_capacity','lifetime') COLLATE utf8_unicode_ci NOT NULL COMMENT 'installed_capacity or lifetime',
  PRIMARY KEY (`scenario_name`(30),`region_id`,`fuel`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `thermal_pp_scenario`
--

INSERT INTO `thermal_pp_scenario` (`scenario_name`, `region_id`, `fuel`, `type`, `installed_capacity`, `lifetime`, `limitation`) VALUES
('lifetime_40years', 0, '0', '0', 0.000, 40, 'lifetime'),
('no_fossils', 0, '0', '0', 0.000, 0, 'installed_capacity'),
('status_quo_2012', 11000, 'gas', 'cc', 14206.000, 0, 'installed_capacity'),
('status_quo_2012', 11000, 'gas', 'gt', 14206.000, 0, 'installed_capacity'),
('status_quo_2012', 11000, 'hard_coal', 'st', 26843.000, 0, 'installed_capacity'),
('status_quo_2012', 11000, 'lignite', 'st', 22389.000, 0, 'installed_capacity'),
('status_quo_2012', 11000, 'oil', 'gt', 4301.000, 0, 'installed_capacity'),
('status_quo_2012', 11000, 'uran', 'st', 12068.000, 0, 'installed_capacity'),
('status_quo_2012', 12000, 'gas', 'cc', 388.000, 0, 'installed_capacity'),
('status_quo_2012', 12000, 'gas', 'gt', 388.000, 0, 'installed_capacity'),
('status_quo_2012', 12000, 'hard_coal', 'st', 19829.000, 0, 'installed_capacity'),
('status_quo_2012', 12000, 'lignite', 'st', 8814.000, 0, 'installed_capacity'),
('status_quo_2012', 13000, 'gas', 'cc', 1086.000, 0, 'installed_capacity'),
('status_quo_2012', 13000, 'gas', 'gt', 1086.000, 0, 'installed_capacity'),
('status_quo_2012', 13000, 'oil', 'gt', 519.000, 0, 'installed_capacity'),
('status_quo_2012', 14000, 'gas', 'cc', 452.000, 0, 'installed_capacity'),
('status_quo_2012', 14000, 'gas', 'gt', 452.000, 0, 'installed_capacity'),
('status_quo_2012', 15000, 'gas', 'cc', 122.000, 0, 'installed_capacity'),
('status_quo_2012', 15000, 'gas', 'gt', 122.000, 0, 'installed_capacity'),
('status_quo_2012', 15000, 'lignite', 'st', 2058.000, 0, 'installed_capacity'),
('status_quo_2012', 16000, 'gas', 'cc', 1605.000, 0, 'installed_capacity'),
('status_quo_2012', 16000, 'gas', 'gt', 1605.000, 0, 'installed_capacity'),
('status_quo_2012', 16000, 'hard_coal', 'st', 3978.000, 0, 'installed_capacity'),
('status_quo_2012', 16000, 'oil', 'gt', 2174.000, 0, 'installed_capacity'),
('status_quo_2012', 16000, 'uran', 'st', 2692.000, 0, 'installed_capacity'),
('status_quo_2012', 17000, 'gas', 'cc', 471.000, 0, 'installed_capacity'),
('status_quo_2012', 17000, 'gas', 'gt', 471.000, 0, 'installed_capacity'),
('status_quo_2012', 17000, 'hard_coal', 'st', 232.000, 0, 'installed_capacity'),
('status_quo_2012', 17000, 'oil', 'gt', 3492.000, 0, 'installed_capacity'),
('status_quo_2012', 17000, 'uran', 'st', 9363.000, 0, 'installed_capacity'),
('status_quo_2012', 18000, 'gas', 'cc', 1449.000, 0, 'installed_capacity'),
('status_quo_2012', 18000, 'gas', 'gt', 1449.000, 0, 'installed_capacity'),
('status_quo_2012', 18000, 'hard_coal', 'st', 4898.000, 0, 'installed_capacity'),
('status_quo_2012', 18000, 'oil', 'gt', 1048.000, 0, 'installed_capacity'),
('status_quo_2012', 19000, 'gas', 'cc', 583.000, 0, 'installed_capacity'),
('status_quo_2012', 19000, 'gas', 'gt', 583.000, 0, 'installed_capacity'),
('status_quo_2012', 20000, 'gas', 'cc', 8615.000, 0, 'installed_capacity'),
('status_quo_2012', 20000, 'gas', 'gt', 8615.000, 0, 'installed_capacity'),
('status_quo_2012', 20000, 'hard_coal', 'st', 5035.000, 0, 'installed_capacity'),
('status_quo_2012', 20000, 'uran', 'st', 504.000, 0, 'installed_capacity'),
('status_quo_2012', 21000, 'gas', 'cc', 4026.000, 0, 'installed_capacity'),
('status_quo_2012', 21000, 'gas', 'gt', 4026.000, 0, 'installed_capacity'),
('status_quo_2012', 21000, 'hard_coal', 'st', 533.000, 0, 'installed_capacity'),
('status_quo_2012', 21000, 'oil', 'gt', 310.000, 0, 'installed_capacity'),
('status_quo_2012', 21000, 'uran', 'st', 5926.000, 0, 'installed_capacity'),
('status_quo_2012', 22000, 'gas', 'cc', 5263.000, 0, 'installed_capacity'),
('status_quo_2012', 22000, 'gas', 'gt', 5263.000, 0, 'installed_capacity'),
('status_quo_2012', 22000, 'hard_coal', 'st', 7914.000, 0, 'installed_capacity'),
('status_quo_2012', 22000, 'oil', 'gt', 9386.000, 0, 'installed_capacity'),
('status_quo_2012', 22000, 'uran', 'st', 63130.000, 0, 'installed_capacity'),
('status_quo_2012', 23000, 'gas', 'cc', 197.000, 0, 'installed_capacity'),
('status_quo_2012', 23000, 'gas', 'gt', 197.000, 0, 'installed_capacity'),
('status_quo_2012', 23000, 'uran', 'st', 3278.000, 0, 'installed_capacity'),
('status_quo_2012', 24000, 'gas', 'cc', 3015.000, 0, 'installed_capacity'),
('status_quo_2012', 24000, 'gas', 'gt', 3015.000, 0, 'installed_capacity'),
('status_quo_2012', 24000, 'hard_coal', 'st', 1379.000, 0, 'installed_capacity'),
('status_quo_2012', 24000, 'oil', 'gt', 424.000, 0, 'installed_capacity'),
('status_quo_2012', 25000, 'gas', 'cc', 5480.000, 0, 'installed_capacity'),
('status_quo_2012', 25000, 'gas', 'gt', 5480.000, 0, 'installed_capacity'),
('status_quo_2012', 25000, 'uran', 'st', 3800.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 11000, '0', '0', 0.000, 40, 'lifetime'),
('status_quo_2012_DE_lifetime_40years', 12000, 'gas', 'cc', 388.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 12000, 'gas', 'gt', 388.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 12000, 'hard_coal', 'st', 19829.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 12000, 'lignite', 'st', 8814.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 13000, 'gas', 'cc', 1086.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 13000, 'gas', 'gt', 1086.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 13000, 'oil', 'gt', 519.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 14000, 'gas', 'cc', 452.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 14000, 'gas', 'gt', 452.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 15000, 'gas', 'cc', 122.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 15000, 'gas', 'gt', 122.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 15000, 'lignite', 'st', 2058.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 16000, 'gas', 'cc', 1605.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 16000, 'gas', 'gt', 1605.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 16000, 'hard_coal', 'st', 3978.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 16000, 'oil', 'gt', 2174.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 16000, 'uran', 'st', 2692.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 17000, 'gas', 'cc', 471.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 17000, 'gas', 'gt', 471.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 17000, 'hard_coal', 'st', 232.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 17000, 'oil', 'gt', 3492.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 17000, 'uran', 'st', 9363.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 18000, 'gas', 'cc', 1449.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 18000, 'gas', 'gt', 1449.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 18000, 'hard_coal', 'st', 4898.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 18000, 'oil', 'gt', 1048.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 19000, 'gas', 'cc', 583.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 19000, 'gas', 'gt', 583.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 20000, 'gas', 'cc', 8615.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 20000, 'gas', 'gt', 8615.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 20000, 'hard_coal', 'st', 5035.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 20000, 'uran', 'st', 504.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 21000, 'gas', 'cc', 4026.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 21000, 'gas', 'gt', 4026.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 21000, 'hard_coal', 'st', 533.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 21000, 'oil', 'gt', 310.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 21000, 'uran', 'st', 5926.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 22000, 'gas', 'cc', 5263.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 22000, 'gas', 'gt', 5263.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 22000, 'hard_coal', 'st', 7914.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 22000, 'oil', 'gt', 9386.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 22000, 'uran', 'st', 63130.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 23000, 'gas', 'cc', 197.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 23000, 'gas', 'gt', 197.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 23000, 'uran', 'st', 3278.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 24000, 'gas', 'cc', 3015.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 24000, 'gas', 'gt', 3015.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 24000, 'hard_coal', 'st', 1379.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 24000, 'oil', 'gt', 424.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 25000, 'gas', 'cc', 5480.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 25000, 'gas', 'gt', 5480.000, 0, 'installed_capacity'),
('status_quo_2012_DE_lifetime_40years', 25000, 'uran', 'st', 3800.000, 0, 'installed_capacity');

-- --------------------------------------------------------

--
-- Table structure for table `wind_offshore_scenario`
--

CREATE TABLE IF NOT EXISTS `wind_offshore_scenario` (
  `scenario_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `region_id` int(8) NOT NULL DEFAULT '0',
  `installed_capacity` decimal(10,2) DEFAULT NULL COMMENT '[MW] including the already installed capacities',
  PRIMARY KEY (`scenario_name`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wind_offshore_scenario`
--

INSERT INTO `wind_offshore_scenario` (`scenario_name`, `region_id`, `installed_capacity`) VALUES
('NEP_2024_A', 11019, 1300.00),
('NEP_2024_A', 11020, 2100.00),
('NEP_2024_A', 11021, 6800.00),
('NEP_2024_B', 11019, 2100.00),
('NEP_2024_B', 11020, 2100.00),
('NEP_2024_B', 11021, 8600.00),
('NEP_2024_C', 11019, 2900.00),
('NEP_2024_C', 11020, 3000.00),
('NEP_2024_C', 11021, 10200.00),
('NEP_2034_B', 11019, 4500.00),
('NEP_2034_B', 11020, 3900.00),
('NEP_2034_B', 11021, 14000.00),
('status_quo_2012', 11019, 48.30),
('status_quo_2012', 11020, 0.00),
('status_quo_2012', 11021, 140.00),
('status_quo_2012', 16000, 26.00),
('status_quo_2012', 17000, 164.00),
('status_quo_2012', 18000, 921.00),
('status_quo_2012', 20000, 248.00),
('status_quo_2012', 21000, 380.00),
('UBA_2050_Regionenverbund', 11019, 9040.00),
('UBA_2050_Regionenverbund', 11020, 7835.00),
('UBA_2050_Regionenverbund', 11021, 28125.00);

-- --------------------------------------------------------

--
-- Table structure for table `wind_onshore_scenario`
--

CREATE TABLE IF NOT EXISTS `wind_onshore_scenario` (
  `scenario_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `region_id` int(8) NOT NULL DEFAULT '0',
  `installed_capacity` decimal(10,2) DEFAULT NULL COMMENT '[MW] including the already installed capacities',
  PRIMARY KEY (`scenario_name`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `wind_onshore_scenario`
--

INSERT INTO `wind_onshore_scenario` (`scenario_name`, `region_id`, `installed_capacity`) VALUES
('NEP_2024_A', 11001, 11715.00),
('NEP_2024_A', 11002, 100.00),
('NEP_2024_A', 11003, 4061.00),
('NEP_2024_A', 11004, 3124.00),
('NEP_2024_A', 11005, 1702.00),
('NEP_2024_A', 11006, 1430.00),
('NEP_2024_A', 11007, 1491.00),
('NEP_2024_A', 11008, 1566.00),
('NEP_2024_A', 11009, 2442.00),
('NEP_2024_A', 11010, 205.00),
('NEP_2024_A', 11011, 186.00),
('NEP_2024_A', 11012, 614.00),
('NEP_2024_A', 11013, 5500.00),
('NEP_2024_A', 11014, 5036.00),
('NEP_2024_A', 11015, 4915.00),
('NEP_2024_A', 11016, 1518.00),
('NEP_2024_A', 11017, 588.00),
('NEP_2024_A', 11018, 507.00),
('NEP_2024_B', 11001, 12834.00),
('NEP_2024_B', 11002, 100.00),
('NEP_2024_B', 11003, 4396.00),
('NEP_2024_B', 11004, 3470.00),
('NEP_2024_B', 11005, 1802.00),
('NEP_2024_B', 11006, 1555.00),
('NEP_2024_B', 11007, 1620.00),
('NEP_2024_B', 11008, 1690.00),
('NEP_2024_B', 11009, 2605.00),
('NEP_2024_B', 11010, 221.00),
('NEP_2024_B', 11011, 233.00),
('NEP_2024_B', 11012, 767.00),
('NEP_2024_B', 11013, 5800.00),
('NEP_2024_B', 11014, 5298.00),
('NEP_2024_B', 11015, 5192.00),
('NEP_2024_B', 11016, 1638.00),
('NEP_2024_B', 11017, 633.00),
('NEP_2024_B', 11018, 546.00),
('NEP_2024_C', 11001, 18289.00),
('NEP_2024_C', 11002, 100.00),
('NEP_2024_C', 11003, 9016.00),
('NEP_2024_C', 11004, 3195.00),
('NEP_2024_C', 11005, 2490.00),
('NEP_2024_C', 11006, 3420.00),
('NEP_2024_C', 11007, 3565.00),
('NEP_2024_C', 11008, 3565.00),
('NEP_2024_C', 11009, 6070.00),
('NEP_2024_C', 11010, 788.00),
('NEP_2024_C', 11011, 1095.00),
('NEP_2024_C', 11012, 3605.00),
('NEP_2024_C', 11013, 13000.00),
('NEP_2024_C', 11014, 6518.00),
('NEP_2024_C', 11015, 6826.00),
('NEP_2024_C', 11016, 3746.00),
('NEP_2024_C', 11017, 2262.00),
('NEP_2024_C', 11018, 1951.00),
('NEP_2034_B', 11001, 17089.00),
('NEP_2034_B', 11002, 100.00),
('NEP_2034_B', 11003, 5857.00),
('NEP_2034_B', 11004, 4554.00),
('NEP_2034_B', 11005, 2400.00),
('NEP_2034_B', 11006, 2052.00),
('NEP_2034_B', 11007, 2139.00),
('NEP_2034_B', 11008, 2241.00),
('NEP_2034_B', 11009, 3500.00),
('NEP_2034_B', 11010, 299.00),
('NEP_2034_B', 11011, 303.00),
('NEP_2034_B', 11012, 997.00),
('NEP_2034_B', 11013, 7700.00),
('NEP_2034_B', 11014, 7097.00),
('NEP_2034_B', 11015, 6918.00),
('NEP_2034_B', 11016, 2154.00),
('NEP_2034_B', 11017, 859.00),
('NEP_2034_B', 11018, 741.00),
('status_quo_2012', 11001, 7697.26),
('status_quo_2012', 11002, 57.40),
('status_quo_2012', 11003, 2709.91),
('status_quo_2012', 11004, 1018.85),
('status_quo_2012', 11005, 1393.51),
('status_quo_2012', 11006, 1062.40),
('status_quo_2012', 11007, 1004.58),
('status_quo_2012', 11008, 768.37),
('status_quo_2012', 11009, 1933.68),
('status_quo_2012', 11010, 66.59),
('status_quo_2012', 11011, 205.69),
('status_quo_2012', 11012, 441.42),
('status_quo_2012', 11013, 3627.85),
('status_quo_2012', 11014, 4644.13),
('status_quo_2012', 11015, 2489.78),
('status_quo_2012', 11016, 1283.64),
('status_quo_2012', 11017, 763.05),
('status_quo_2012', 11018, 26.39),
('status_quo_2012', 12000, 2562.00),
('status_quo_2012', 13000, 275.00),
('status_quo_2012', 14000, 58.00),
('status_quo_2012', 15000, 267.00),
('status_quo_2012', 16000, 261.00),
('status_quo_2012', 17000, 3771.00),
('status_quo_2012', 18000, 3245.00),
('status_quo_2012', 19000, 730.00),
('status_quo_2012', 20000, 2261.00),
('status_quo_2012', 21000, 1015.00),
('status_quo_2012', 22000, 7704.00),
('status_quo_2012', 23000, 45.00),
('status_quo_2012', 24000, 1307.00),
('status_quo_2012', 25000, 263.00),
('UBA_2050_Regionenverbund', 11001, 9784.00),
('UBA_2050_Regionenverbund', 11002, 129.00),
('UBA_2050_Regionenverbund', 11003, 4349.00),
('UBA_2050_Regionenverbund', 11004, 4113.00),
('UBA_2050_Regionenverbund', 11005, 1353.00),
('UBA_2050_Regionenverbund', 11006, 1791.00),
('UBA_2050_Regionenverbund', 11007, 1867.00),
('UBA_2050_Regionenverbund', 11008, 2005.00),
('UBA_2050_Regionenverbund', 11009, 3586.00),
('UBA_2050_Regionenverbund', 11010, 1829.00),
('UBA_2050_Regionenverbund', 11011, 1427.00),
('UBA_2050_Regionenverbund', 11012, 4694.00),
('UBA_2050_Regionenverbund', 11013, 2693.00),
('UBA_2050_Regionenverbund', 11014, 3540.00),
('UBA_2050_Regionenverbund', 11015, 3727.00),
('UBA_2050_Regionenverbund', 11016, 3335.00),
('UBA_2050_Regionenverbund', 11017, 5250.00),
('UBA_2050_Regionenverbund', 11018, 4528.00);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `renewable_scenario`
--
ALTER TABLE `renewable_scenario`
  ADD CONSTRAINT `renewable_scenario_ibfk_4` FOREIGN KEY (`runofriver_scenario`) REFERENCES `runofriver_scenario` (`scenario_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `renewable_scenario_ibfk_5` FOREIGN KEY (`geothermal_scenario`) REFERENCES `geothermal_scenario` (`scenario_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `renewable_scenario_ibfk_6` FOREIGN KEY (`biomass_scenario`) REFERENCES `biomass_scenario` (`scenario_name`),
  ADD CONSTRAINT `renewable_scenario_ibfk_7` FOREIGN KEY (`solar_scenario`) REFERENCES `solar_scenario` (`scenario_name`),
  ADD CONSTRAINT `renewable_scenario_ibfk_8` FOREIGN KEY (`wind_onshore_scenario`) REFERENCES `wind_onshore_scenario` (`scenario_name`),
  ADD CONSTRAINT `renewable_scenario_ibfk_9` FOREIGN KEY (`wind_offshore_scenario`) REFERENCES `wind_offshore_scenario` (`scenario_name`);

--
-- Constraints for table `storage_scenario`
--
ALTER TABLE `storage_scenario`
  ADD CONSTRAINT `storage_scenario_ibfk_1` FOREIGN KEY (`hydro_storage_scenario`) REFERENCES `hydro_storage_scenario` (`scenario_name`) ON UPDATE CASCADE,
  ADD CONSTRAINT `storage_scenario_ibfk_2` FOREIGN KEY (`other_storage_scenario`) REFERENCES `other_storage_scenario` (`scenario_name`) ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
